/*
 * Decompiled with CFR 0.152.
 */
package com.mugui.spring.net.websocket;

import com.mugui.spring.net.bean.NetBag;
import com.mugui.spring.net.websocket.WebSocketSessionManager;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@ServerEndpoint(value="/")
@Component
public class WebHandle {
    private WebSocketSessionManager webSocketSessionManager;

    public WebHandle() {
        ApplicationContext app = (ApplicationContext)System.getProperties().get("Application");
        if (app != null) {
            this.webSocketSessionManager = app.getBean(WebSocketSessionManager.class);
        }
    }

    @OnOpen
    public void onOpen(Session session) {
        System.out.println(WebHandle.class.getName() + "->onOpen " + session.getId());
        this.webSocketSessionManager.add(session.getId(), session);
    }

    @OnMessage
    public void onMessage(Session session, byte[] message) {
        System.out.println(WebHandle.class.getName() + "->onMessage byte:" + new String(message));
        NetBag bag = NetBag.newBean(NetBag.class, new String(message));
        if (bag.getFunc().startsWith("sub.")) {
            bag.setFunc(bag.getFunc().substring(4));
            this.webSocketSessionManager.sub(session, bag);
        } else if (bag.getFunc().startsWith("unsub.")) {
            bag.setFunc(bag.getFunc().substring(6));
            this.webSocketSessionManager.unsub(session, bag);
        }
    }

    @OnMessage
    public void onMessage(Session session, String message) {
        System.out.println(WebHandle.class.getName() + "->onMessage string:" + message);
        NetBag bag = NetBag.newBean(NetBag.class, message);
        if (bag.getFunc().startsWith("sub.")) {
            bag.setFunc(bag.getFunc().substring(4));
            this.webSocketSessionManager.sub(session, bag);
        } else if (bag.getFunc().startsWith("unsub.")) {
            bag.setFunc(bag.getFunc().substring(6));
            this.webSocketSessionManager.unsub(session, bag);
        }
    }

    @OnError
    public void onError(Session session, Throwable error) throws Throwable {
        System.out.println(WebHandle.class.getName() + "->onError");
        this.webSocketSessionManager.del(session.getId());
        throw error;
    }

    @OnClose
    public void onClose(Session session) {
        System.out.println(WebHandle.class.getName() + "->onClose");
        this.webSocketSessionManager.del(session.getId());
    }
}

