/*
 * Decompiled with CFR 0.152.
 */
package com.mugui.spring.util;

import java.time.Duration;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisClientConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;
import redis.clients.jedis.JedisPoolConfig;

@Component
public class RedisAccess {
    private String REDISTHOST = null;
    private int REDISPORT;
    private String REDISPASSWORD = null;
    @Autowired
    private Environment env;
    public static ThreadLocal<HashMap<Integer, StringRedisTemplate>> threadlocal = new ThreadLocal();

    private StringRedisTemplate redisTemplate(RedisConnectionFactory redisConnectionFactory) {
        StringRedisTemplate template = new StringRedisTemplate();
        template.setConnectionFactory(redisConnectionFactory);
        template.afterPropertiesSet();
        return template;
    }

    public RedisConnectionFactory createRedisFactory(int select) {
        if (StringUtils.isBlank(this.REDISTHOST)) {
            this.REDISTHOST = this.env.getProperty("spring.redis.host");
            this.REDISPORT = Integer.parseInt(this.env.getProperty("spring.redis.port"));
            this.REDISPASSWORD = this.env.getProperty("spring.redis.password");
        }
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxTotal(100);
        poolConfig.setMaxIdle(200);
        poolConfig.setMaxWaitMillis(30000L);
        poolConfig.setMinIdle(10);
        poolConfig.setTestOnBorrow(true);
        poolConfig.setTestOnReturn(false);
        poolConfig.setTestWhileIdle(true);
        JedisClientConfiguration clientConfig = JedisClientConfiguration.builder().usePooling().poolConfig(poolConfig).and().readTimeout(Duration.ofMillis(30000L)).build();
        RedisStandaloneConfiguration redisConfig = new RedisStandaloneConfiguration();
        redisConfig.setHostName(this.REDISTHOST);
        if (StringUtils.isNotBlank(this.REDISPASSWORD)) {
            redisConfig.setPassword(RedisPassword.of(this.REDISPASSWORD));
        }
        redisConfig.setPort(this.REDISPORT);
        redisConfig.setDatabase(select);
        return new JedisConnectionFactory(redisConfig, clientConfig);
    }

    public StringRedisTemplate getRedisClient() {
        return this.getRedisClient(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StringRedisTemplate getRedisClient(int i2) {
        StringRedisTemplate stringRedisTemplate;
        HashMap<Integer, StringRedisTemplate> hashMap = threadlocal.get();
        if (hashMap == null) {
            ThreadLocal<HashMap<Integer, StringRedisTemplate>> threadLocal = threadlocal;
            synchronized (threadLocal) {
                hashMap = threadlocal.get();
                if (hashMap == null) {
                    hashMap = new HashMap();
                    threadlocal.set(hashMap);
                }
            }
        }
        if ((stringRedisTemplate = hashMap.get(i2)) != null) return stringRedisTemplate;
        Class<RedisAccess> clazz = RedisAccess.class;
        synchronized (RedisAccess.class) {
            stringRedisTemplate = hashMap.get(i2);
            if (stringRedisTemplate != null) return stringRedisTemplate;
            stringRedisTemplate = this.redisTemplate(this.createRedisFactory(i2));
            hashMap.put(i2, stringRedisTemplate);
            // ** MonitorExit[var4_5] (shouldn't be in output)
            return stringRedisTemplate;
        }
    }

    public void push(String key, String bean2) {
        StringRedisTemplate jedis = null;
        jedis = this.getRedisClient();
        jedis.opsForList().rightPush(key, bean2.toString());
    }

    public String pop(String key) {
        StringRedisTemplate jedis = null;
        jedis = this.getRedisClient();
        return (String)jedis.opsForList().leftPop(key);
    }

    public String get(String key) {
        StringRedisTemplate jedis = null;
        jedis = this.getRedisClient();
        return (String)jedis.opsForValue().get(key);
    }

    public void set(String key, String bean2) {
        StringRedisTemplate jedis = null;
        jedis = this.getRedisClient();
        jedis.opsForValue().set(key, bean2);
    }

    public void del(String key) {
    }
}

