/*
 * Decompiled with CFR 0.152.
 */
package com.mugui.sql.util;

public class StringEscape {
    private static boolean isEscapeNeededForString(String str, int len) {
        boolean needsHexEscape = false;
        int i2 = 0;
        while (i2 < len) {
            char c = str.charAt(i2);
            switch (c) {
                case '\u0000': {
                    needsHexEscape = true;
                    break;
                }
                case '\n': {
                    needsHexEscape = true;
                    break;
                }
                case '\r': {
                    needsHexEscape = true;
                    break;
                }
                case '\\': {
                    needsHexEscape = true;
                    break;
                }
                case '\'': {
                    needsHexEscape = true;
                    break;
                }
                case '\"': {
                    needsHexEscape = true;
                    break;
                }
                case '\u001a': {
                    needsHexEscape = true;
                    break;
                }
            }
            if (needsHexEscape) break;
            ++i2;
        }
        return needsHexEscape;
    }

    public static String escapeRawString(String escapeStr) {
        int stringLength = escapeStr.length();
        if (StringEscape.isEscapeNeededForString(escapeStr, stringLength)) {
            StringBuilder buf = new StringBuilder((int)((double)escapeStr.length() * 1.1));
            int i2 = 0;
            while (i2 < stringLength) {
                char c = escapeStr.charAt(i2);
                switch (c) {
                    case '\u0000': {
                        buf.append('\\');
                        buf.append('0');
                        break;
                    }
                    case '\n': {
                        buf.append('\\');
                        buf.append('n');
                        break;
                    }
                    case '\r': {
                        buf.append('\\');
                        buf.append('r');
                        break;
                    }
                    case '\\': {
                        buf.append('\\');
                        buf.append('\\');
                        break;
                    }
                    case '\'': {
                        buf.append('\\');
                        buf.append('\'');
                        break;
                    }
                    case '\"': {
                        buf.append('\\');
                        buf.append('\"');
                        break;
                    }
                    case '\u001a': {
                        buf.append('\\');
                        buf.append('Z');
                        break;
                    }
                    default: {
                        buf.append(c);
                    }
                }
                ++i2;
            }
            return buf.toString();
        }
        return escapeStr;
    }

    public static String escapeString(String escapeStr) {
        if (escapeStr.matches("'(.+)'")) {
            escapeStr = escapeStr.substring(1, escapeStr.length() - 1);
        }
        return "'" + StringEscape.escapeRawString(escapeStr) + "'";
    }
}

