/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.masterslave;

import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.masterslave.Connections;
import io.lettuce.core.masterslave.MasterSlaveUtils;
import io.lettuce.core.models.role.RedisNodeDescription;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuples;

class AsyncConnections {
    private final Map<RedisURI, CompletableFuture<StatefulRedisConnection<String, String>>> connections = new TreeMap<RedisURI, CompletableFuture<StatefulRedisConnection<String, String>>>(MasterSlaveUtils.RedisURIComparator.INSTANCE);
    private final List<RedisNodeDescription> nodeList;

    AsyncConnections(List<RedisNodeDescription> nodeList) {
        this.nodeList = nodeList;
    }

    public void addConnection(RedisURI redisURI, CompletableFuture<StatefulRedisConnection<String, String>> connection) {
        this.connections.put(redisURI, connection);
    }

    public Mono<Connections> asMono(Duration timeout, ScheduledExecutorService timeoutExecutor) {
        Connections connections = new Connections(this.connections.size(), this.nodeList);
        for (Map.Entry<RedisURI, CompletableFuture<StatefulRedisConnection<String, String>>> entry : this.connections.entrySet()) {
            CompletableFuture<StatefulRedisConnection<String, String>> future = entry.getValue();
            future.whenComplete((connection, throwable) -> {
                if (throwable != null) {
                    connections.accept((Throwable)throwable);
                } else {
                    connections.accept(Tuples.of(entry.getKey(), connection));
                }
            });
        }
        return Mono.fromCompletionStage(connections.getOrTimeout(timeout, timeoutExecutor));
    }
}

