/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.beans.factory.annotation;

import org.apache.dubbo.config.annotation.Reference;
import org.apache.dubbo.config.annotation.Service;
import org.apache.dubbo.config.spring.util.AnnotationUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class ServiceBeanNameBuilder {
    private static final String SEPARATOR = ":";
    private final String interfaceClassName;
    private final Environment environment;
    private String version;
    private String group;

    private ServiceBeanNameBuilder(Class<?> interfaceClass, Environment environment2) {
        this(interfaceClass.getName(), environment2);
    }

    private ServiceBeanNameBuilder(String interfaceClassName, Environment environment2) {
        this.interfaceClassName = interfaceClassName;
        this.environment = environment2;
    }

    private ServiceBeanNameBuilder(AnnotationAttributes attributes, Class<?> defaultInterfaceClass, Environment environment2) {
        this(AnnotationUtils.resolveInterfaceName(attributes, defaultInterfaceClass), environment2);
        this.group((String)AnnotationUtils.getAttribute(attributes, "group"));
        this.version((String)AnnotationUtils.getAttribute(attributes, "version"));
    }

    public static ServiceBeanNameBuilder create(AnnotationAttributes attributes, Class<?> defaultInterfaceClass, Environment environment2) {
        return new ServiceBeanNameBuilder(attributes, defaultInterfaceClass, environment2);
    }

    public static ServiceBeanNameBuilder create(Class<?> interfaceClass, Environment environment2) {
        return new ServiceBeanNameBuilder(interfaceClass, environment2);
    }

    public static ServiceBeanNameBuilder create(Service service, Class<?> interfaceClass, Environment environment2) {
        return ServiceBeanNameBuilder.create(org.springframework.core.annotation.AnnotationUtils.getAnnotationAttributes(service, false, false), interfaceClass, environment2);
    }

    public static ServiceBeanNameBuilder create(Reference reference, Class<?> interfaceClass, Environment environment2) {
        return ServiceBeanNameBuilder.create(org.springframework.core.annotation.AnnotationUtils.getAnnotationAttributes(reference, false, false), interfaceClass, environment2);
    }

    private static void append(StringBuilder builder, String value) {
        if (StringUtils.hasText(value)) {
            builder.append(SEPARATOR).append(value);
        }
    }

    public ServiceBeanNameBuilder group(String group) {
        this.group = group;
        return this;
    }

    public ServiceBeanNameBuilder version(String version) {
        this.version = version;
        return this;
    }

    public String build() {
        StringBuilder beanNameBuilder = new StringBuilder("ServiceBean");
        ServiceBeanNameBuilder.append(beanNameBuilder, this.interfaceClassName);
        ServiceBeanNameBuilder.append(beanNameBuilder, this.version);
        ServiceBeanNameBuilder.append(beanNameBuilder, this.group);
        String rawBeanName = beanNameBuilder.toString();
        return this.environment.resolvePlaceholders(rawBeanName);
    }
}

