/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.configcenter.consul;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.kv.model.GetValue;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.configcenter.ConfigChangeEvent;
import org.apache.dubbo.configcenter.ConfigChangeType;
import org.apache.dubbo.configcenter.ConfigurationListener;
import org.apache.dubbo.configcenter.DynamicConfiguration;

public class ConsulDynamicConfiguration
implements DynamicConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ConsulDynamicConfiguration.class);
    private static final int DEFAULT_PORT = 8500;
    private static final int DEFAULT_WATCH_TIMEOUT = 60000;
    private static final String WATCH_TIMEOUT = "consul-watch-timeout";
    private URL url;
    private String rootPath;
    private ConsulClient client;
    private int watchTimeout = -1;
    private ConcurrentMap<String, ConsulKVWatcher> watchers = new ConcurrentHashMap<String, ConsulKVWatcher>();
    private ConcurrentMap<String, Long> consulIndexes = new ConcurrentHashMap<String, Long>();
    private ExecutorService watcherService = Executors.newCachedThreadPool(new NamedThreadFactory("dubbo-consul-configuration-watcher", true));

    public ConsulDynamicConfiguration(URL url) {
        this.url = url;
        this.rootPath = "/" + url.getParameter("config.namespace", "dubbo") + "/" + "config";
        this.watchTimeout = this.buildWatchTimeout(url);
        String host = url.getHost();
        int port = url.getPort() != 0 ? url.getPort() : 8500;
        this.client = new ConsulClient(host, port);
    }

    @Override
    public void addListener(String key, String group, ConfigurationListener listener) {
        logger.info("register listener " + listener.getClass() + " for config with key: " + key + ", group: " + group);
        String normalizedKey = this.convertKey(group, key);
        ConsulKVWatcher watcher = this.watchers.putIfAbsent(normalizedKey, new ConsulKVWatcher(normalizedKey));
        if (watcher == null) {
            watcher = (ConsulKVWatcher)this.watchers.get(normalizedKey);
            this.watcherService.submit(watcher);
        }
        watcher.addListener(listener);
    }

    @Override
    public void removeListener(String key, String group, ConfigurationListener listener) {
        logger.info("unregister listener " + listener.getClass() + " for config with key: " + key + ", group: " + group);
        ConsulKVWatcher watcher = (ConsulKVWatcher)this.watchers.get(this.convertKey(group, key));
        if (watcher != null) {
            watcher.removeListener(listener);
        }
    }

    @Override
    public String getRule(String key, String group, long timeout) throws IllegalStateException {
        return (String)this.getInternalProperty(this.convertKey(group, key));
    }

    @Override
    public String getProperties(String key, String group, long timeout) throws IllegalStateException {
        if (StringUtils.isEmpty(group)) {
            group = "dubbo";
        }
        return (String)this.getInternalProperty(this.convertKey(group, key));
    }

    @Override
    public Object getInternalProperty(String key) {
        logger.info("get config from: " + key);
        Response<GetValue> response = this.getValue(key);
        if (response != null) {
            GetValue value = (GetValue)response.getValue();
            this.consulIndexes.put(key, response.getConsulIndex());
            return value != null ? value.getDecodedValue() : null;
        }
        return null;
    }

    private Response<GetValue> getValue(String key) {
        try {
            Long currentIndex = this.consulIndexes.computeIfAbsent(key, k -> -1L);
            return this.client.getKVValue(key, new QueryParams((long)this.watchTimeout, currentIndex.longValue()));
        }
        catch (Throwable t) {
            logger.warn("fail to get value for key: " + key);
            return null;
        }
    }

    private String convertKey(String group, String key) {
        return this.rootPath + "/" + group + "/" + key;
    }

    private int buildWatchTimeout(URL url) {
        return url.getParameter(WATCH_TIMEOUT, 60000) / 1000;
    }

    private class ConsulKVWatcher
    implements Runnable {
        private String key;
        private Set<ConfigurationListener> listeners;
        private boolean running = true;
        private boolean existing = false;

        public ConsulKVWatcher(String key) {
            this.key = key;
            this.listeners = new HashSet<ConfigurationListener>();
        }

        @Override
        public void run() {
            while (this.running) {
                Long lastIndex = ConsulDynamicConfiguration.this.consulIndexes.computeIfAbsent(this.key, k -> -1L);
                Response response = ConsulDynamicConfiguration.this.getValue(this.key);
                if (response == null) {
                    try {
                        Thread.sleep(ConsulDynamicConfiguration.this.watchTimeout);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                GetValue getValue = (GetValue)response.getValue();
                Long currentIndex = response.getConsulIndex();
                if (currentIndex == null || currentIndex <= lastIndex) continue;
                ConsulDynamicConfiguration.this.consulIndexes.put(this.key, currentIndex);
                ConfigChangeEvent event = null;
                if (getValue != null) {
                    String value = getValue.getDecodedValue();
                    if (this.existing) {
                        logger.info("notify change for key: " + this.key + ", the changed value is: " + value);
                        event = new ConfigChangeEvent(this.key, value);
                    } else {
                        logger.info("notify change for key: " + this.key + ", the added value is: " + value);
                        event = new ConfigChangeEvent(this.key, value, ConfigChangeType.ADDED);
                    }
                } else if (this.existing) {
                    logger.info("notify change for key: " + this.key + ", the value is deleted");
                    event = new ConfigChangeEvent(this.key, null, ConfigChangeType.DELETED);
                }
                boolean bl = this.existing = getValue != null;
                if (event == null) continue;
                for (ConfigurationListener listener : this.listeners) {
                    listener.process(event);
                }
            }
        }

        private void addListener(ConfigurationListener listener) {
            this.listeners.add(listener);
        }

        private void removeListener(ConfigurationListener listener) {
            this.listeners.remove(listener);
        }

        private void stop() {
            this.running = false;
        }
    }
}

