/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.definition.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.metadata.definition.util.JaketConfigurationUtils;

public final class ClassUtils {
    public static String getCodeSource(Class<?> clazz) {
        ProtectionDomain protectionDomain = clazz.getProtectionDomain();
        if (protectionDomain == null || protectionDomain.getCodeSource() == null) {
            return null;
        }
        CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
        URL location = codeSource.getLocation();
        if (location == null) {
            return null;
        }
        String path = codeSource.getLocation().toExternalForm();
        if (path.endsWith(".jar") && path.contains("/")) {
            return path.substring(path.lastIndexOf(47) + 1);
        }
        return path;
    }

    public static List<Field> getNonStaticFields(Class<?> clazz) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Class<?> target = clazz; target != null && !JaketConfigurationUtils.isExcludedType(target); target = target.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = target.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
                result.add(field);
            }
        }
        return result;
    }

    public static List<Method> getPublicNonStaticMethods(Class<?> clazz) {
        Method[] methods;
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : methods = clazz.getMethods()) {
            int mod = method.getModifiers();
            if (!Modifier.isPublic(mod) || Modifier.isStatic(mod)) continue;
            result.add(method);
        }
        return result;
    }

    private ClassUtils() {
    }
}

