/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.model;

import java.lang.reflect.Method;
import java.util.Map;

public class ConsumerMethodModel {
    private final Method method;
    private final String[] parameterTypes;
    private final Class<?>[] parameterClasses;
    private final Class<?> returnClass;
    private final String methodName;
    private final boolean generic;
    private final AsyncMethodInfo asyncInfo;

    public ConsumerMethodModel(Method method, Map<String, Object> attributes) {
        this.method = method;
        this.parameterClasses = method.getParameterTypes();
        this.returnClass = method.getReturnType();
        this.parameterTypes = this.createParamSignature(this.parameterClasses);
        this.methodName = method.getName();
        this.generic = this.methodName.equals("$invoke") && this.parameterTypes != null && this.parameterTypes.length == 3;
        this.asyncInfo = attributes != null ? (AsyncMethodInfo)attributes.get(this.methodName) : null;
    }

    public Method getMethod() {
        return this.method;
    }

    public Class<?> getReturnClass() {
        return this.returnClass;
    }

    public AsyncMethodInfo getAsyncInfo() {
        return this.asyncInfo;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String[] getParameterTypes() {
        return this.parameterTypes;
    }

    private String[] createParamSignature(Class<?>[] args) {
        if (args == null || args.length == 0) {
            return new String[0];
        }
        String[] paramSig = new String[args.length];
        for (int x = 0; x < args.length; ++x) {
            paramSig[x] = args[x].getName();
        }
        return paramSig;
    }

    public boolean isGeneric() {
        return this.generic;
    }

    public Class<?>[] getParameterClasses() {
        return this.parameterClasses;
    }

    public static class AsyncMethodInfo {
        private Object oninvokeInstance;
        private Method oninvokeMethod;
        private Object onreturnInstance;
        private Method onreturnMethod;
        private Object onthrowInstance;
        private Method onthrowMethod;

        public Object getOninvokeInstance() {
            return this.oninvokeInstance;
        }

        public void setOninvokeInstance(Object oninvokeInstance) {
            this.oninvokeInstance = oninvokeInstance;
        }

        public Method getOninvokeMethod() {
            return this.oninvokeMethod;
        }

        public void setOninvokeMethod(Method oninvokeMethod) {
            this.oninvokeMethod = oninvokeMethod;
        }

        public Object getOnreturnInstance() {
            return this.onreturnInstance;
        }

        public void setOnreturnInstance(Object onreturnInstance) {
            this.onreturnInstance = onreturnInstance;
        }

        public Method getOnreturnMethod() {
            return this.onreturnMethod;
        }

        public void setOnreturnMethod(Method onreturnMethod) {
            this.onreturnMethod = onreturnMethod;
        }

        public Object getOnthrowInstance() {
            return this.onthrowInstance;
        }

        public void setOnthrowInstance(Object onthrowInstance) {
            this.onthrowInstance = onthrowInstance;
        }

        public Method getOnthrowMethod() {
            return this.onthrowMethod;
        }

        public void setOnthrowMethod(Method onthrowMethod) {
            this.onthrowMethod = onthrowMethod;
        }
    }
}

