/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.bcel.classfile;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tomcat.util.bcel.classfile.Annotations;
import org.apache.tomcat.util.bcel.classfile.ClassFormatException;
import org.apache.tomcat.util.bcel.classfile.ConstantPool;
import org.apache.tomcat.util.bcel.classfile.ConstantUtf8;
import org.apache.tomcat.util.bcel.classfile.JavaClass;
import org.apache.tomcat.util.bcel.classfile.Utility;

public final class ClassParser {
    private static final int MAGIC = -889275714;
    private final DataInput dataInputStream;
    private String class_name;
    private String superclass_name;
    private int access_flags;
    private String[] interface_names;
    private ConstantPool constant_pool;
    private Annotations runtimeVisibleAnnotations;
    private static final int BUFSIZE = 8192;
    private static final String[] INTERFACES_EMPTY_ARRAY = new String[0];

    public ClassParser(InputStream inputStream) {
        this.dataInputStream = new DataInputStream(new BufferedInputStream(inputStream, 8192));
    }

    public JavaClass parse() throws IOException, ClassFormatException {
        this.readID();
        this.readVersion();
        this.readConstantPool();
        this.readClassInfo();
        this.readInterfaces();
        this.readFields();
        this.readMethods();
        this.readAttributes();
        return new JavaClass(this.class_name, this.superclass_name, this.access_flags, this.constant_pool, this.interface_names, this.runtimeVisibleAnnotations);
    }

    private void readAttributes() throws IOException, ClassFormatException {
        int attributes_count = this.dataInputStream.readUnsignedShort();
        for (int i2 = 0; i2 < attributes_count; ++i2) {
            int name_index = this.dataInputStream.readUnsignedShort();
            ConstantUtf8 c = (ConstantUtf8)this.constant_pool.getConstant(name_index, (byte)1);
            String name = c.getBytes();
            int length = this.dataInputStream.readInt();
            if (name.equals("RuntimeVisibleAnnotations")) {
                if (this.runtimeVisibleAnnotations != null) {
                    throw new ClassFormatException("RuntimeVisibleAnnotations attribute is not allowed more than once in a class file");
                }
                this.runtimeVisibleAnnotations = new Annotations(this.dataInputStream, this.constant_pool);
                continue;
            }
            Utility.skipFully(this.dataInputStream, length);
        }
    }

    private void readClassInfo() throws IOException, ClassFormatException {
        this.access_flags = this.dataInputStream.readUnsignedShort();
        if ((this.access_flags & 0x200) != 0) {
            this.access_flags |= 0x400;
        }
        if ((this.access_flags & 0x400) != 0 && (this.access_flags & 0x10) != 0) {
            throw new ClassFormatException("Class can't be both final and abstract");
        }
        int class_name_index = this.dataInputStream.readUnsignedShort();
        this.class_name = Utility.getClassName(this.constant_pool, class_name_index);
        int superclass_name_index = this.dataInputStream.readUnsignedShort();
        this.superclass_name = superclass_name_index > 0 ? Utility.getClassName(this.constant_pool, superclass_name_index) : "java.lang.Object";
    }

    private void readConstantPool() throws IOException, ClassFormatException {
        this.constant_pool = new ConstantPool(this.dataInputStream);
    }

    private void readFields() throws IOException, ClassFormatException {
        int fields_count = this.dataInputStream.readUnsignedShort();
        for (int i2 = 0; i2 < fields_count; ++i2) {
            Utility.swallowFieldOrMethod(this.dataInputStream);
        }
    }

    private void readID() throws IOException, ClassFormatException {
        if (this.dataInputStream.readInt() != -889275714) {
            throw new ClassFormatException("It is not a Java .class file");
        }
    }

    private void readInterfaces() throws IOException, ClassFormatException {
        int interfaces_count = this.dataInputStream.readUnsignedShort();
        if (interfaces_count > 0) {
            this.interface_names = new String[interfaces_count];
            for (int i2 = 0; i2 < interfaces_count; ++i2) {
                int index = this.dataInputStream.readUnsignedShort();
                this.interface_names[i2] = Utility.getClassName(this.constant_pool, index);
            }
        } else {
            this.interface_names = INTERFACES_EMPTY_ARRAY;
        }
    }

    private void readMethods() throws IOException, ClassFormatException {
        int methods_count = this.dataInputStream.readUnsignedShort();
        for (int i2 = 0; i2 < methods_count; ++i2) {
            Utility.swallowFieldOrMethod(this.dataInputStream);
        }
    }

    private void readVersion() throws IOException, ClassFormatException {
        Utility.skipFully(this.dataInputStream, 4);
    }
}

