/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.integration;

import javax.management.MBeanServer;
import javax.sql.DataSource;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.integration.IntegrationAutoConfigurationScanRegistrar;
import org.springframework.boot.autoconfigure.integration.IntegrationDataSourceInitializer;
import org.springframework.boot.autoconfigure.integration.IntegrationProperties;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jmx.JmxAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.integration.config.EnableIntegration;
import org.springframework.integration.config.EnableIntegrationManagement;
import org.springframework.integration.config.IntegrationManagementConfigurer;
import org.springframework.integration.gateway.GatewayProxyFactoryBean;
import org.springframework.integration.jdbc.store.JdbcMessageStore;
import org.springframework.integration.jmx.config.EnableIntegrationMBeanExport;
import org.springframework.integration.monitor.IntegrationMBeanExporter;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={EnableIntegration.class})
@EnableConfigurationProperties(value={IntegrationProperties.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class, JmxAutoConfiguration.class})
public class IntegrationAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={JdbcMessageStore.class})
    @ConditionalOnSingleCandidate(value=DataSource.class)
    protected static class IntegrationJdbcConfiguration {
        protected IntegrationJdbcConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public IntegrationDataSourceInitializer integrationDataSourceInitializer(DataSource dataSource, ResourceLoader resourceLoader, IntegrationProperties properties) {
            return new IntegrationDataSourceInitializer(dataSource, resourceLoader, properties);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={GatewayProxyFactoryBean.class})
    @Import(value={IntegrationAutoConfigurationScanRegistrar.class})
    protected static class IntegrationComponentScanConfiguration {
        protected IntegrationComponentScanConfiguration() {
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={EnableIntegrationManagement.class})
    @ConditionalOnMissingBean(value={IntegrationManagementConfigurer.class}, name={"integrationManagementConfigurer"}, search=SearchStrategy.CURRENT)
    protected static class IntegrationManagementConfiguration {
        protected IntegrationManagementConfiguration() {
        }

        @Configuration(proxyBeanMethods=false)
        @EnableIntegrationManagement(defaultCountsEnabled="true")
        protected static class EnableIntegrationManagementConfiguration {
            protected EnableIntegrationManagementConfiguration() {
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={EnableIntegrationMBeanExport.class})
    @ConditionalOnMissingBean(value={IntegrationMBeanExporter.class}, search=SearchStrategy.CURRENT)
    @ConditionalOnBean(value={MBeanServer.class})
    @ConditionalOnProperty(prefix="spring.jmx", name={"enabled"}, havingValue="true", matchIfMissing=true)
    protected static class IntegrationJmxConfiguration {
        protected IntegrationJmxConfiguration() {
        }

        @Bean
        public IntegrationMBeanExporter integrationMbeanExporter(BeanFactory beanFactory, Environment environment2) {
            IntegrationMBeanExporter exporter = new IntegrationMBeanExporter();
            String defaultDomain = environment2.getProperty("spring.jmx.default-domain");
            if (StringUtils.hasLength(defaultDomain)) {
                exporter.setDefaultDomain(defaultDomain);
            }
            String serverBean = environment2.getProperty("spring.jmx.server", "mbeanServer");
            exporter.setServer(beanFactory.getBean(serverBean, MBeanServer.class));
            return exporter;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @EnableIntegration
    protected static class IntegrationConfiguration {
        protected IntegrationConfiguration() {
        }
    }
}

