/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.session;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.data.mongo.MongoDataAutoConfiguration;
import org.springframework.boot.autoconfigure.data.mongo.MongoReactiveDataAutoConfiguration;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.autoconfigure.data.redis.RedisReactiveAutoConfiguration;
import org.springframework.boot.autoconfigure.hazelcast.HazelcastAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.JdbcTemplateAutoConfiguration;
import org.springframework.boot.autoconfigure.session.NonUniqueSessionRepositoryException;
import org.springframework.boot.autoconfigure.session.SessionProperties;
import org.springframework.boot.autoconfigure.session.SessionRepositoryFilterConfiguration;
import org.springframework.boot.autoconfigure.session.SessionRepositoryUnavailableException;
import org.springframework.boot.autoconfigure.session.SessionStoreMappings;
import org.springframework.boot.autoconfigure.session.StoreType;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.reactive.HttpHandlerAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.web.servlet.server.Session;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.session.ReactiveSessionRepository;
import org.springframework.session.Session;
import org.springframework.session.SessionRepository;
import org.springframework.session.security.web.authentication.SpringSessionRememberMeServices;
import org.springframework.session.web.http.CookieHttpSessionIdResolver;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.session.web.http.DefaultCookieSerializer;
import org.springframework.session.web.http.HttpSessionIdResolver;
import org.springframework.util.ClassUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Session.class})
@ConditionalOnWebApplication
@EnableConfigurationProperties(value={ServerProperties.class, SessionProperties.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class, HazelcastAutoConfiguration.class, JdbcTemplateAutoConfiguration.class, MongoDataAutoConfiguration.class, MongoReactiveDataAutoConfiguration.class, RedisAutoConfiguration.class, RedisReactiveAutoConfiguration.class})
@AutoConfigureBefore(value={HttpHandlerAutoConfiguration.class})
public class SessionAutoConfiguration {
    private static final String REMEMBER_ME_SERVICES_CLASS = "org.springframework.security.web.authentication.RememberMeServices";

    static class ReactiveSessionRepositoryValidator
    extends AbstractSessionRepositoryValidator {
        ReactiveSessionRepositoryValidator(SessionProperties sessionProperties, ObjectProvider<ReactiveSessionRepository<?>> sessionRepositoryProvider) {
            super(sessionProperties, sessionRepositoryProvider);
        }
    }

    static class ServletSessionRepositoryValidator
    extends AbstractSessionRepositoryValidator {
        ServletSessionRepositoryValidator(SessionProperties sessionProperties, ObjectProvider<SessionRepository<?>> sessionRepositoryProvider) {
            super(sessionProperties, sessionRepositoryProvider);
        }
    }

    static abstract class AbstractSessionRepositoryValidator {
        private final SessionProperties sessionProperties;
        private final ObjectProvider<?> sessionRepositoryProvider;

        protected AbstractSessionRepositoryValidator(SessionProperties sessionProperties, ObjectProvider<?> sessionRepositoryProvider) {
            this.sessionProperties = sessionProperties;
            this.sessionRepositoryProvider = sessionRepositoryProvider;
        }

        @PostConstruct
        void checkSessionRepository() {
            StoreType storeType = this.sessionProperties.getStoreType();
            if (storeType != StoreType.NONE && this.sessionRepositoryProvider.getIfAvailable() == null && storeType != null) {
                throw new SessionRepositoryUnavailableException("No session repository could be auto-configured, check your configuration (session store type is '" + storeType.name().toLowerCase(Locale.ENGLISH) + "')", storeType);
            }
        }
    }

    static class ReactiveSessionRepositoryImplementationValidator
    extends AbstractSessionRepositoryImplementationValidator {
        ReactiveSessionRepositoryImplementationValidator(ApplicationContext applicationContext, SessionProperties sessionProperties) {
            super(applicationContext, sessionProperties, Arrays.asList("org.springframework.session.data.redis.ReactiveRedisSessionRepository", "org.springframework.session.data.mongo.ReactiveMongoSessionRepository"));
        }
    }

    static class ServletSessionRepositoryImplementationValidator
    extends AbstractSessionRepositoryImplementationValidator {
        ServletSessionRepositoryImplementationValidator(ApplicationContext applicationContext, SessionProperties sessionProperties) {
            super(applicationContext, sessionProperties, Arrays.asList("org.springframework.session.hazelcast.HazelcastIndexedSessionRepository", "org.springframework.session.jdbc.JdbcIndexedSessionRepository", "org.springframework.session.data.mongo.MongoIndexedSessionRepository", "org.springframework.session.data.redis.RedisIndexedSessionRepository"));
        }
    }

    static abstract class AbstractSessionRepositoryImplementationValidator {
        private final List<String> candidates;
        private final ClassLoader classLoader;
        private final SessionProperties sessionProperties;

        AbstractSessionRepositoryImplementationValidator(ApplicationContext applicationContext, SessionProperties sessionProperties, List<String> candidates) {
            this.classLoader = applicationContext.getClassLoader();
            this.sessionProperties = sessionProperties;
            this.candidates = candidates;
        }

        @PostConstruct
        void checkAvailableImplementations() {
            ArrayList availableCandidates = new ArrayList();
            for (String candidate : this.candidates) {
                this.addCandidateIfAvailable(availableCandidates, candidate);
            }
            StoreType storeType = this.sessionProperties.getStoreType();
            if (availableCandidates.size() > 1 && storeType == null) {
                throw new NonUniqueSessionRepositoryException(availableCandidates);
            }
        }

        private void addCandidateIfAvailable(List<Class<?>> candidates, String type) {
            try {
                Class<?> candidate = this.classLoader.loadClass(type);
                if (candidate != null) {
                    candidates.add(candidate);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static class ServletSessionConfigurationImportSelector
    extends SessionConfigurationImportSelector {
        ServletSessionConfigurationImportSelector() {
        }

        @Override
        public String[] selectImports(AnnotationMetadata importingClassMetadata) {
            return super.selectImports(WebApplicationType.SERVLET);
        }
    }

    static class ReactiveSessionConfigurationImportSelector
    extends SessionConfigurationImportSelector {
        ReactiveSessionConfigurationImportSelector() {
        }

        @Override
        public String[] selectImports(AnnotationMetadata importingClassMetadata) {
            return super.selectImports(WebApplicationType.REACTIVE);
        }
    }

    static abstract class SessionConfigurationImportSelector
    implements ImportSelector {
        SessionConfigurationImportSelector() {
        }

        protected final String[] selectImports(WebApplicationType webApplicationType) {
            return (String[])Arrays.stream(StoreType.values()).map(type -> SessionStoreMappings.getConfigurationClass(webApplicationType, type)).toArray(String[]::new);
        }
    }

    static class DefaultCookieSerializerCondition
    extends AnyNestedCondition {
        DefaultCookieSerializerCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnBean(value={CookieHttpSessionIdResolver.class})
        @ConditionalOnMissingBean(value={CookieSerializer.class})
        static class CookieHttpSessionIdResolverAvailable {
            CookieHttpSessionIdResolverAvailable() {
            }
        }

        @ConditionalOnMissingBean(value={HttpSessionIdResolver.class, CookieSerializer.class})
        static class NoComponentsAvailable {
            NoComponentsAvailable() {
            }
        }
    }

    static class RememberMeServicesCookieSerializerCustomizer {
        RememberMeServicesCookieSerializerCustomizer() {
        }

        void apply(DefaultCookieSerializer cookieSerializer) {
            cookieSerializer.setRememberMeRequestAttribute(SpringSessionRememberMeServices.REMEMBER_ME_LOGIN_ATTR);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    @Import(value={ReactiveSessionRepositoryValidator.class})
    static class ReactiveSessionConfiguration {
        ReactiveSessionConfiguration() {
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnMissingBean(value={ReactiveSessionRepository.class})
        @Import(value={ReactiveSessionRepositoryImplementationValidator.class, ReactiveSessionConfigurationImportSelector.class})
        static class ReactiveSessionRepositoryConfiguration {
            ReactiveSessionRepositoryConfiguration() {
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @Import(value={ServletSessionRepositoryValidator.class, SessionRepositoryFilterConfiguration.class})
    static class ServletSessionConfiguration {
        ServletSessionConfiguration() {
        }

        @Bean
        @Conditional(value={DefaultCookieSerializerCondition.class})
        DefaultCookieSerializer cookieSerializer(ServerProperties serverProperties) {
            Session.Cookie cookie = serverProperties.getServlet().getSession().getCookie();
            DefaultCookieSerializer cookieSerializer = new DefaultCookieSerializer();
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            map.from(cookie::getName).to(cookieSerializer::setCookieName);
            map.from(cookie::getDomain).to(cookieSerializer::setDomainName);
            map.from(cookie::getPath).to(cookieSerializer::setCookiePath);
            map.from(cookie::getHttpOnly).to(cookieSerializer::setUseHttpOnlyCookie);
            map.from(cookie::getSecure).to(cookieSerializer::setUseSecureCookie);
            map.from(cookie::getMaxAge).to(maxAge -> cookieSerializer.setCookieMaxAge((int)maxAge.getSeconds()));
            if (ClassUtils.isPresent(SessionAutoConfiguration.REMEMBER_ME_SERVICES_CLASS, this.getClass().getClassLoader())) {
                new RememberMeServicesCookieSerializerCustomizer().apply(cookieSerializer);
            }
            return cookieSerializer;
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnMissingBean(value={SessionRepository.class})
        @Import(value={ServletSessionRepositoryImplementationValidator.class, ServletSessionConfigurationImportSelector.class})
        static class ServletSessionRepositoryConfiguration {
            ServletSessionRepositoryConfiguration() {
            }
        }
    }
}

