/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.transaction.jta;

import bitronix.tm.BitronixTransactionManager;
import bitronix.tm.Configuration;
import bitronix.tm.TransactionManagerServices;
import bitronix.tm.jndi.BitronixContext;
import java.io.File;
import javax.jms.Message;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizers;
import org.springframework.boot.autoconfigure.transaction.jta.JtaProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.jdbc.XADataSourceWrapper;
import org.springframework.boot.jms.XAConnectionFactoryWrapper;
import org.springframework.boot.jta.bitronix.BitronixDependentBeanFactoryPostProcessor;
import org.springframework.boot.jta.bitronix.BitronixXAConnectionFactoryWrapper;
import org.springframework.boot.jta.bitronix.BitronixXADataSourceWrapper;
import org.springframework.boot.system.ApplicationHome;
import org.springframework.context.annotation.Bean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.util.StringUtils;

@org.springframework.context.annotation.Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={JtaProperties.class})
@ConditionalOnClass(value={JtaTransactionManager.class, BitronixContext.class})
@ConditionalOnMissingBean(value={PlatformTransactionManager.class})
class BitronixJtaConfiguration {
    BitronixJtaConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    @ConfigurationProperties(prefix="spring.jta.bitronix.properties")
    Configuration bitronixConfiguration(JtaProperties jtaProperties) {
        Configuration config = TransactionManagerServices.getConfiguration();
        if (StringUtils.hasText(jtaProperties.getTransactionManagerId())) {
            config.setServerId(jtaProperties.getTransactionManagerId());
        }
        File logBaseDir = this.getLogBaseDir(jtaProperties);
        config.setLogPart1Filename(new File(logBaseDir, "part1.btm").getAbsolutePath());
        config.setLogPart2Filename(new File(logBaseDir, "part2.btm").getAbsolutePath());
        config.setDisableJmx(true);
        return config;
    }

    private File getLogBaseDir(JtaProperties jtaProperties) {
        if (StringUtils.hasLength(jtaProperties.getLogDir())) {
            return new File(jtaProperties.getLogDir());
        }
        File home = new ApplicationHome().getDir();
        return new File(home, "transaction-logs");
    }

    @Bean
    @ConditionalOnMissingBean(value={TransactionManager.class})
    BitronixTransactionManager bitronixTransactionManager(Configuration configuration) {
        return TransactionManagerServices.getTransactionManager();
    }

    @Bean
    @ConditionalOnMissingBean(value={XADataSourceWrapper.class})
    BitronixXADataSourceWrapper xaDataSourceWrapper() {
        return new BitronixXADataSourceWrapper();
    }

    @Bean
    @ConditionalOnMissingBean
    static BitronixDependentBeanFactoryPostProcessor bitronixDependentBeanFactoryPostProcessor() {
        return new BitronixDependentBeanFactoryPostProcessor();
    }

    @Bean
    JtaTransactionManager transactionManager(UserTransaction userTransaction, TransactionManager transactionManager, ObjectProvider<TransactionManagerCustomizers> transactionManagerCustomizers) {
        JtaTransactionManager jtaTransactionManager = new JtaTransactionManager(userTransaction, transactionManager);
        transactionManagerCustomizers.ifAvailable(customizers -> customizers.customize(jtaTransactionManager));
        return jtaTransactionManager;
    }

    @org.springframework.context.annotation.Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Message.class})
    static class BitronixJtaJmsConfiguration {
        BitronixJtaJmsConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={XAConnectionFactoryWrapper.class})
        BitronixXAConnectionFactoryWrapper xaConnectionFactoryWrapper() {
            return new BitronixXAConnectionFactoryWrapper();
        }
    }
}

