/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import org.springframework.data.redis.connection.DefaultMessage;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.util.Assert;
import redis.clients.jedis.BinaryJedisPubSub;

class JedisMessageListener
extends BinaryJedisPubSub {
    private final MessageListener listener;

    JedisMessageListener(MessageListener listener) {
        Assert.notNull((Object)listener, "message listener is required");
        this.listener = listener;
    }

    @Override
    public void onMessage(byte[] channel, byte[] message) {
        this.listener.onMessage(new DefaultMessage(channel, message), null);
    }

    @Override
    public void onPMessage(byte[] pattern, byte[] channel, byte[] message) {
        this.listener.onMessage(new DefaultMessage(channel, message), pattern);
    }

    @Override
    public void onPSubscribe(byte[] pattern, int subscribedChannels) {
    }

    @Override
    public void onPUnsubscribe(byte[] pattern, int subscribedChannels) {
    }

    @Override
    public void onSubscribe(byte[] channel, int subscribedChannels) {
    }

    @Override
    public void onUnsubscribe(byte[] channel, int subscribedChannels) {
    }
}

