/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.BitFieldArgs;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import io.lettuce.core.cluster.api.sync.RedisClusterCommands;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import lombok.NonNull;
import org.springframework.dao.DataAccessException;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.BitFieldSubCommands;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceResult;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class LettuceStringCommands
implements RedisStringCommands {
    @NonNull
    private final LettuceConnection connection;

    @Override
    public byte[] get(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().get(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().get(key)));
                return null;
            }
            return (byte[])this.getConnection().get(key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] getSet(byte[] key, byte[] value) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)value, "Value must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().getset(key, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().getset(key, value)));
                return null;
            }
            return this.getConnection().getset(key, value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<byte[]> mGet(byte[] ... keys) {
        Assert.notNull((Object)keys, "Keys must not be null!");
        Assert.noNullElements((Object[])keys, "Keys must not contain null elements!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().mget((K[])keys), LettuceConverters.keyValueListUnwrapper()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().mget((K[])keys), LettuceConverters.keyValueListUnwrapper()));
                return null;
            }
            return LettuceConverters.keyValueListUnwrapper().convert(this.getConnection().mget((K[])keys));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean set(byte[] key, byte[] value) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)value, "Value must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().set(key, value), Converters.stringToBooleanConverter()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().set(key, value), Converters.stringToBooleanConverter()));
                return null;
            }
            return Converters.stringToBoolean(this.getConnection().set(key, value));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean set(byte[] key, byte[] value, Expiration expiration, RedisStringCommands.SetOption option) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)value, "Value must not be null!");
        Assert.notNull((Object)expiration, "Expiration must not be null!");
        Assert.notNull((Object)option, "Option must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().set(key, value, LettuceConverters.toSetArgs(expiration, option)), Converters.stringToBooleanConverter(), () -> false));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().set(key, value, LettuceConverters.toSetArgs(expiration, option)), Converters.stringToBooleanConverter(), () -> false));
                return null;
            }
            return Converters.stringToBoolean(this.getConnection().set(key, value, LettuceConverters.toSetArgs(expiration, option)));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean setNX(byte[] key, byte[] value) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)value, "Value must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().setnx(key, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().setnx(key, value)));
                return null;
            }
            return this.getConnection().setnx(key, value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean setEx(byte[] key, long seconds, byte[] value) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)value, "Value must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().setex(key, seconds, value), Converters.stringToBooleanConverter()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().setex(key, seconds, value), Converters.stringToBooleanConverter()));
                return null;
            }
            return Converters.stringToBoolean(this.getConnection().setex(key, seconds, value));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean pSetEx(byte[] key, long milliseconds, byte[] value) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)value, "Value must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().psetex(key, milliseconds, value), Converters.stringToBooleanConverter()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().psetex(key, milliseconds, value), Converters.stringToBooleanConverter()));
                return null;
            }
            return Converters.stringToBoolean(this.getConnection().psetex(key, milliseconds, value));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean mSet(Map<byte[], byte[]> tuples) {
        Assert.notNull(tuples, "Tuples must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().mset(tuples), Converters.stringToBooleanConverter()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().mset(tuples), Converters.stringToBooleanConverter()));
                return null;
            }
            return Converters.stringToBoolean(this.getConnection().mset(tuples));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean mSetNX(Map<byte[], byte[]> tuples) {
        Assert.notNull(tuples, "Tuples must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().msetnx(tuples)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().msetnx(tuples)));
                return null;
            }
            return this.getConnection().msetnx(tuples);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long incr(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().incr(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().incr(key)));
                return null;
            }
            return this.getConnection().incr(key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long incrBy(byte[] key, long value) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().incrby(key, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().incrby(key, value)));
                return null;
            }
            return this.getConnection().incrby(key, value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Double incrBy(byte[] key, double value) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().incrbyfloat(key, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().incrbyfloat(key, value)));
                return null;
            }
            return this.getConnection().incrbyfloat(key, value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long decr(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().decr(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().decr(key)));
                return null;
            }
            return this.getConnection().decr(key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long decrBy(byte[] key, long value) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().decrby(key, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().decrby(key, value)));
                return null;
            }
            return this.getConnection().decrby(key, value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long append(byte[] key, byte[] value) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)value, "Value must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().append(key, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().append(key, value)));
                return null;
            }
            return this.getConnection().append(key, value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] getRange(byte[] key, long start, long end) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().getrange(key, start, end)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().getrange(key, start, end)));
                return null;
            }
            return (byte[])this.getConnection().getrange(key, start, end);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void setRange(byte[] key, byte[] value, long offset) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)value, "Value must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceStatusResult(this.getAsyncConnection().setrange(key, offset, value)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceStatusResult(this.getAsyncConnection().setrange(key, offset, value)));
                return;
            }
            this.getConnection().setrange(key, offset, value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean getBit(byte[] key, long offset) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().getbit(key, offset), LettuceConverters.longToBoolean()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().getbit(key, offset), LettuceConverters.longToBoolean()));
                return null;
            }
            return LettuceConverters.toBoolean(this.getConnection().getbit(key, offset));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean setBit(byte[] key, long offset, boolean value) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().setbit(key, offset, LettuceConverters.toInt(value)), LettuceConverters.longToBooleanConverter()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().setbit(key, offset, LettuceConverters.toInt(value)), LettuceConverters.longToBooleanConverter()));
                return null;
            }
            return LettuceConverters.longToBooleanConverter().convert(this.getConnection().setbit(key, offset, LettuceConverters.toInt(value)));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long bitCount(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().bitcount(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().bitcount(key)));
                return null;
            }
            return this.getConnection().bitcount(key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long bitCount(byte[] key, long start, long end) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().bitcount(key, start, end)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().bitcount(key, start, end)));
                return null;
            }
            return this.getConnection().bitcount(key, start, end);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<Long> bitField(byte[] key, BitFieldSubCommands subCommands) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)subCommands, "Command must not be null!");
        BitFieldArgs args = LettuceConverters.toBitFieldArgs(subCommands);
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().bitfield(key, args)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().bitfield(key, args)));
                return null;
            }
            return this.getConnection().bitfield(key, args);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long bitOp(RedisStringCommands.BitOperation op, byte[] destination, byte[] ... keys) {
        Assert.notNull((Object)op, "BitOperation must not be null!");
        Assert.notNull((Object)destination, "Destination key must not be null!");
        if (op == RedisStringCommands.BitOperation.NOT && keys.length > 1) {
            throw new UnsupportedOperationException("Bitop NOT should only be performed against one key");
        }
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.asyncBitOp(op, destination, keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.asyncBitOp(op, destination, keys)));
                return null;
            }
            return this.syncBitOp(op, destination, keys);
        }
        catch (UnsupportedOperationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    private Future<Long> asyncBitOp(RedisStringCommands.BitOperation op, byte[] destination, byte[] ... keys) {
        switch (op) {
            case AND: {
                return this.getAsyncConnection().bitopAnd(destination, (byte[][])keys);
            }
            case OR: {
                return this.getAsyncConnection().bitopOr(destination, (byte[][])keys);
            }
            case XOR: {
                return this.getAsyncConnection().bitopXor(destination, (byte[][])keys);
            }
            case NOT: {
                if (keys.length != 1) {
                    throw new UnsupportedOperationException("Bitop NOT should only be performed against one key");
                }
                return this.getAsyncConnection().bitopNot(destination, keys[0]);
            }
        }
        throw new UnsupportedOperationException("Bit operation " + (Object)((Object)op) + " is not supported");
    }

    private Long syncBitOp(RedisStringCommands.BitOperation op, byte[] destination, byte[] ... keys) {
        switch (op) {
            case AND: {
                return this.getConnection().bitopAnd(destination, (byte[][])keys);
            }
            case OR: {
                return this.getConnection().bitopOr(destination, (byte[][])keys);
            }
            case XOR: {
                return this.getConnection().bitopXor(destination, (byte[][])keys);
            }
            case NOT: {
                if (keys.length != 1) {
                    throw new UnsupportedOperationException("Bitop NOT should only be performed against one key");
                }
                return this.getConnection().bitopNot(destination, keys[0]);
            }
        }
        throw new UnsupportedOperationException("Bit operation " + (Object)((Object)op) + " is not supported");
    }

    @Override
    @Nullable
    public Long bitPos(byte[] key, boolean bit, Range<Long> range) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull(range, "Range must not be null! Use Range.unbounded() instead.");
        try {
            if (this.isPipelined() || this.isQueueing()) {
                RedisClusterAsyncCommands<byte[], byte[]> connection = this.getAsyncConnection();
                RedisFuture<Long> futureResult = range.getLowerBound().isBounded() ? (range.getUpperBound().isBounded() ? connection.bitpos(key, bit, LettuceStringCommands.getLowerValue(range), LettuceStringCommands.getUpperValue(range)) : connection.bitpos(key, bit, LettuceStringCommands.getLowerValue(range))) : connection.bitpos(key, bit);
                if (this.isPipelined()) {
                    this.pipeline(this.connection.newLettuceResult(futureResult));
                } else if (this.isQueueing()) {
                    this.transaction(this.connection.newLettuceResult(futureResult));
                }
                return null;
            }
            if (range.getLowerBound().isBounded()) {
                if (range.getUpperBound().isBounded()) {
                    return this.getConnection().bitpos(key, bit, LettuceStringCommands.getLowerValue(range), LettuceStringCommands.getUpperValue(range));
                }
                return this.getConnection().bitpos(key, bit, LettuceStringCommands.getLowerValue(range));
            }
            return this.getConnection().bitpos(key, bit);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long strLen(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().strlen(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().strlen(key)));
                return null;
            }
            return this.getConnection().strlen(key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    private boolean isPipelined() {
        return this.connection.isPipelined();
    }

    private boolean isQueueing() {
        return this.connection.isQueueing();
    }

    private void pipeline(LettuceResult result) {
        this.connection.pipeline(result);
    }

    private void transaction(LettuceResult result) {
        this.connection.transaction(result);
    }

    RedisClusterAsyncCommands<byte[], byte[]> getAsyncConnection() {
        return this.connection.getAsyncConnection();
    }

    public RedisClusterCommands<byte[], byte[]> getConnection() {
        return this.connection.getConnection();
    }

    private DataAccessException convertLettuceAccessException(Exception ex) {
        return this.connection.convertLettuceAccessException(ex);
    }

    private static <T extends Comparable<T>> T getUpperValue(Range<T> range) {
        return (T)((Comparable)range.getUpperBound().getValue().orElseThrow(() -> new IllegalArgumentException("Range does not contain upper bound value!")));
    }

    private static <T extends Comparable<T>> T getLowerValue(Range<T> range) {
        return (T)((Comparable)range.getLowerBound().getValue().orElseThrow(() -> new IllegalArgumentException("Range does not contain lower bound value!")));
    }

    public LettuceStringCommands(@NonNull LettuceConnection connection) {
        if (connection == null) {
            throw new NullPointerException("connection is marked non-null but is null");
        }
        this.connection = connection;
    }
}

