/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.stream;

import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.NumberUtils;
import org.springframework.util.StringUtils;

public class RecordId {
    private static final String GENERATE_ID = "*";
    private static final String DELIMITER = "-";
    private static final RecordId AUTOGENERATED = new RecordId("*"){

        @Override
        public Long getSequence() {
            return null;
        }

        @Override
        public Long getTimestamp() {
            return null;
        }

        @Override
        public boolean shouldBeAutoGenerated() {
            return true;
        }
    };
    private final String raw;

    private RecordId(String raw) {
        this.raw = raw;
    }

    public static RecordId of(@Nullable String value) {
        if (value == null || GENERATE_ID.equals(value)) {
            return RecordId.autoGenerate();
        }
        Assert.isTrue(value.contains(DELIMITER), "Invalid id format. Please use the 'millisecondsTime-sequenceNumber' format.");
        return new RecordId(value);
    }

    public static RecordId of(long millisecondsTime, long sequenceNumber) {
        return RecordId.of(millisecondsTime + DELIMITER + sequenceNumber);
    }

    public static RecordId autoGenerate() {
        return AUTOGENERATED;
    }

    @Nullable
    public Long getTimestamp() {
        return this.value(0);
    }

    @Nullable
    public Long getSequence() {
        return this.value(1);
    }

    public boolean shouldBeAutoGenerated() {
        return false;
    }

    public String getValue() {
        return this.raw;
    }

    public String toString() {
        return this.raw;
    }

    private Long value(int index) {
        return NumberUtils.parseNumber(StringUtils.split(this.raw, DELIMITER)[index], Long.class);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecordId)) {
            return false;
        }
        RecordId other = (RecordId)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$raw = this.raw;
        String other$raw = other.raw;
        return !(this$raw == null ? other$raw != null : !this$raw.equals(other$raw));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RecordId;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $raw = this.raw;
        result = result * 59 + ($raw == null ? 43 : $raw.hashCode());
        return result;
    }
}

