/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.core.AbstractOperations;
import org.springframework.data.redis.core.GeoOperations;
import org.springframework.data.redis.core.RedisTemplate;

class DefaultGeoOperations<K, M>
extends AbstractOperations<K, M>
implements GeoOperations<K, M> {
    DefaultGeoOperations(RedisTemplate<K, M> template) {
        super(template);
    }

    @Override
    public Long add(K key, Point point, M member) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawMember = this.rawValue(member);
        return this.execute(connection -> connection.geoAdd(rawKey, point, rawMember), true);
    }

    @Override
    public Long add(K key, RedisGeoCommands.GeoLocation<M> location) {
        return this.add(key, location.getPoint(), location.getName());
    }

    @Override
    public Long add(K key, Map<M, Point> memberCoordinateMap) {
        byte[] rawKey = this.rawKey(key);
        HashMap<byte[], Point> rawMemberCoordinateMap = new HashMap<byte[], Point>();
        for (M member : memberCoordinateMap.keySet()) {
            byte[] rawMember = this.rawValue(member);
            rawMemberCoordinateMap.put(rawMember, memberCoordinateMap.get(member));
        }
        return this.execute(connection -> connection.geoAdd(rawKey, rawMemberCoordinateMap), true);
    }

    @Override
    public Long add(K key, Iterable<RedisGeoCommands.GeoLocation<M>> locations) {
        LinkedHashMap<M, Point> memberCoordinateMap = new LinkedHashMap<M, Point>();
        for (RedisGeoCommands.GeoLocation<M> location : locations) {
            memberCoordinateMap.put(location.getName(), location.getPoint());
        }
        return this.add(key, memberCoordinateMap);
    }

    @Override
    public Distance distance(K key, M member1, M member2) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawMember1 = this.rawValue(member1);
        byte[] rawMember2 = this.rawValue(member2);
        return this.execute(connection -> connection.geoDist(rawKey, rawMember1, rawMember2), true);
    }

    @Override
    public Distance distance(K key, M member1, M member2, Metric metric) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawMember1 = this.rawValue(member1);
        byte[] rawMember2 = this.rawValue(member2);
        return this.execute(connection -> connection.geoDist(rawKey, rawMember1, rawMember2, metric), true);
    }

    @Override
    public List<String> hash(K key, M ... members) {
        byte[] rawKey = this.rawKey(key);
        byte[][] rawMembers = this.rawValues(members);
        return this.execute(connection -> connection.geoHash(rawKey, rawMembers), true);
    }

    @Override
    public List<Point> position(K key, M ... members) {
        byte[] rawKey = this.rawKey(key);
        byte[][] rawMembers = this.rawValues(members);
        return this.execute(connection -> connection.geoPos(rawKey, rawMembers), true);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(K key, Circle within) {
        byte[] rawKey = this.rawKey(key);
        GeoResults raw = this.execute(connection -> connection.geoRadius(rawKey, within), true);
        return this.deserializeGeoResults(raw);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(K key, Circle within, RedisGeoCommands.GeoRadiusCommandArgs args) {
        byte[] rawKey = this.rawKey(key);
        GeoResults raw = this.execute(connection -> connection.geoRadius(rawKey, within, args), true);
        return this.deserializeGeoResults(raw);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(K key, M member, double radius) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawMember = this.rawValue(member);
        GeoResults raw = this.execute(connection -> connection.geoRadiusByMember(rawKey, rawMember, radius), true);
        return this.deserializeGeoResults(raw);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(K key, M member, Distance distance) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawMember = this.rawValue(member);
        GeoResults raw = this.execute(connection -> connection.geoRadiusByMember(rawKey, rawMember, distance), true);
        return this.deserializeGeoResults(raw);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(K key, M member, Distance distance, RedisGeoCommands.GeoRadiusCommandArgs param) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawMember = this.rawValue(member);
        GeoResults raw = this.execute(connection -> connection.geoRadiusByMember(rawKey, rawMember, distance, param), true);
        return this.deserializeGeoResults(raw);
    }

    @Override
    public Long remove(K key, M ... members) {
        byte[] rawKey = this.rawKey(key);
        byte[][] rawMembers = this.rawValues(members);
        return this.execute(connection -> connection.zRem(rawKey, rawMembers), true);
    }
}

