/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.convert;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.redis.core.convert.BinaryConverters;
import org.springframework.data.redis.core.convert.Jsr310Converters;

public class RedisCustomConversions
extends CustomConversions {
    private static final CustomConversions.StoreConversions STORE_CONVERSIONS;
    private static final List<Object> STORE_CONVERTERS;

    public RedisCustomConversions() {
        this(Collections.emptyList());
    }

    public RedisCustomConversions(List<?> converters) {
        super(STORE_CONVERSIONS, converters);
    }

    static {
        ArrayList<Object> converters = new ArrayList<Object>();
        converters.add(new BinaryConverters.StringToBytesConverter());
        converters.add(new BinaryConverters.BytesToStringConverter());
        converters.add(new BinaryConverters.NumberToBytesConverter());
        converters.add(new BinaryConverters.BytesToNumberConverterFactory());
        converters.add(new BinaryConverters.EnumToBytesConverter());
        converters.add(new BinaryConverters.BytesToEnumConverterFactory());
        converters.add(new BinaryConverters.BooleanToBytesConverter());
        converters.add(new BinaryConverters.BytesToBooleanConverter());
        converters.add(new BinaryConverters.DateToBytesConverter());
        converters.add(new BinaryConverters.BytesToDateConverter());
        converters.add(new BinaryConverters.UuidToBytesConverter());
        converters.add(new BinaryConverters.BytesToUuidConverter());
        converters.addAll(Jsr310Converters.getConvertersToRegister());
        STORE_CONVERTERS = Collections.unmodifiableList(converters);
        STORE_CONVERSIONS = CustomConversions.StoreConversions.of(SimpleTypeHolder.DEFAULT, STORE_CONVERTERS);
    }
}

