/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.repository.support;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.keyvalue.core.KeyValueTemplate;
import org.springframework.data.keyvalue.core.query.KeyValueQuery;
import org.springframework.data.redis.core.RedisKeyValueTemplate;
import org.springframework.data.redis.core.convert.IndexResolver;
import org.springframework.data.redis.core.convert.PathIndexResolver;
import org.springframework.data.redis.repository.query.ExampleQueryMapper;
import org.springframework.data.redis.repository.query.RedisOperationChain;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.query.QueryByExampleExecutor;
import org.springframework.util.Assert;

public class QueryByExampleRedisExecutor<T>
implements QueryByExampleExecutor<T> {
    private final EntityInformation<T, ?> entityInformation;
    private final RedisKeyValueTemplate keyValueTemplate;
    private final ExampleQueryMapper mapper;

    public QueryByExampleRedisExecutor(EntityInformation<T, ?> entityInformation, RedisKeyValueTemplate keyValueTemplate) {
        this(entityInformation, keyValueTemplate, keyValueTemplate.getConverter().getIndexResolver() != null ? keyValueTemplate.getConverter().getIndexResolver() : new PathIndexResolver(keyValueTemplate.getMappingContext()));
    }

    public QueryByExampleRedisExecutor(EntityInformation<T, ?> entityInformation, RedisKeyValueTemplate keyValueTemplate, IndexResolver indexResolver) {
        Assert.notNull(entityInformation, "EntityInformation must not be null!");
        Assert.notNull((Object)keyValueTemplate, "RedisKeyValueTemplate must not be null!");
        Assert.notNull((Object)indexResolver, "IndexResolver must not be null!");
        this.entityInformation = entityInformation;
        this.keyValueTemplate = keyValueTemplate;
        this.mapper = new ExampleQueryMapper(keyValueTemplate.getMappingContext(), indexResolver);
    }

    @Override
    public <S extends T> Optional<S> findOne(Example<S> example) {
        RedisOperationChain operationChain = this.createQuery(example);
        KeyValueQuery<RedisOperationChain> query = new KeyValueQuery<RedisOperationChain>(operationChain);
        Iterator iterator = ((KeyValueTemplate)this.keyValueTemplate).find(query.limit(2), this.entityInformation.getJavaType()).iterator();
        Optional result = Optional.empty();
        if (iterator.hasNext()) {
            result = Optional.of(iterator.next());
            if (iterator.hasNext()) {
                throw new IncorrectResultSizeDataAccessException(1);
            }
        }
        return result;
    }

    @Override
    public <S extends T> Iterable<S> findAll(Example<S> example) {
        RedisOperationChain operationChain = this.createQuery(example);
        return ((KeyValueTemplate)this.keyValueTemplate).find(new KeyValueQuery<RedisOperationChain>(operationChain), this.entityInformation.getJavaType());
    }

    @Override
    public <S extends T> Iterable<S> findAll(Example<S> example, Sort sort) {
        throw new UnsupportedOperationException("Ordering is not supported");
    }

    @Override
    public <S extends T> Page<S> findAll(Example<S> example, Pageable pageable) {
        Assert.notNull((Object)pageable, "Pageable must not be null!");
        RedisOperationChain operationChain = this.createQuery(example);
        KeyValueQuery<RedisOperationChain> query = new KeyValueQuery<RedisOperationChain>(operationChain);
        Iterable result = ((KeyValueTemplate)this.keyValueTemplate).find(query.orderBy(pageable.getSort()).skip(pageable.getOffset()).limit(pageable.getPageSize()), this.entityInformation.getJavaType());
        long count = operationChain.isEmpty() ? this.keyValueTemplate.count(this.entityInformation.getJavaType()) : this.keyValueTemplate.count(query, this.entityInformation.getJavaType());
        ArrayList list = new ArrayList();
        for (Object t : result) {
            list.add(t);
        }
        return new PageImpl(list, pageable, count);
    }

    @Override
    public <S extends T> long count(Example<S> example) {
        RedisOperationChain operationChain = this.createQuery(example);
        return this.keyValueTemplate.count(new KeyValueQuery<RedisOperationChain>(operationChain), this.entityInformation.getJavaType());
    }

    @Override
    public <S extends T> boolean exists(Example<S> example) {
        return this.count(example) > 0L;
    }

    private <S extends T> RedisOperationChain createQuery(Example<S> example) {
        Assert.notNull(example, "Example must not be null!");
        return this.mapper.getMappedExample(example);
    }
}

