/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.util;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public final class ByteUtils {
    private ByteUtils() {
    }

    public static byte[] concat(byte[] array1, byte[] array2) {
        byte[] result = Arrays.copyOf(array1, array1.length + array2.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    public static byte[] concatAll(byte[] ... arrays) {
        if (arrays.length == 0) {
            return new byte[0];
        }
        if (arrays.length == 1) {
            return arrays[0];
        }
        byte[] cur = ByteUtils.concat(arrays[0], arrays[1]);
        for (int i2 = 2; i2 < arrays.length; ++i2) {
            cur = ByteUtils.concat(cur, arrays[i2]);
        }
        return cur;
    }

    public static byte[][] split(byte[] source, int c) {
        if (ObjectUtils.isEmpty((Object)source)) {
            return new byte[0][];
        }
        ArrayList<byte[]> bytes = new ArrayList<byte[]>();
        int offset = 0;
        for (int i2 = 0; i2 <= source.length; ++i2) {
            if (i2 == source.length) {
                bytes.add(Arrays.copyOfRange(source, offset, i2));
                break;
            }
            if (source[i2] != c) continue;
            bytes.add(Arrays.copyOfRange(source, offset, i2));
            offset = i2 + 1;
        }
        return (byte[][])bytes.toArray((T[])new byte[bytes.size()][]);
    }

    public static byte[][] mergeArrays(byte[] firstArray, byte[] ... additionalArrays) {
        Assert.notNull((Object)firstArray, "first array must not be null");
        Assert.notNull((Object)additionalArrays, "additional arrays must not be null");
        byte[][] result = new byte[additionalArrays.length + 1][];
        result[0] = firstArray;
        System.arraycopy(additionalArrays, 0, result, 1, additionalArrays.length);
        return result;
    }

    public static byte[] getBytes(ByteBuffer byteBuffer) {
        Assert.notNull((Object)byteBuffer, "ByteBuffer must not be null!");
        ByteBuffer duplicate = byteBuffer.duplicate();
        byte[] bytes = new byte[duplicate.remaining()];
        duplicate.get(bytes);
        return bytes;
    }

    public static boolean startsWith(byte[] haystack, byte[] prefix) {
        return ByteUtils.startsWith(haystack, prefix, 0);
    }

    public static boolean startsWith(byte[] haystack, byte[] prefix, int offset) {
        int to = offset;
        int prefixOffset = 0;
        int prefixLength = prefix.length;
        if (offset < 0 || offset > haystack.length - prefixLength) {
            return false;
        }
        while (--prefixLength >= 0) {
            if (haystack[to++] == prefix[prefixOffset++]) continue;
            return false;
        }
        return true;
    }

    public static int indexOf(byte[] haystack, byte needle) {
        for (int i2 = 0; i2 < haystack.length; ++i2) {
            if (haystack[i2] != needle) continue;
            return i2;
        }
        return -1;
    }

    public static ByteBuffer getByteBuffer(String theString) {
        return ByteUtils.getByteBuffer(theString, StandardCharsets.UTF_8);
    }

    public static ByteBuffer getByteBuffer(String theString, Charset charset) {
        Assert.notNull((Object)theString, "The String must not be null!");
        Assert.notNull((Object)charset, "The String must not be null!");
        return charset.encode(theString);
    }

    public static byte[] extractBytes(ByteBuffer buffer) {
        ByteBuffer duplicate = buffer.duplicate();
        byte[] bytes = new byte[duplicate.remaining()];
        duplicate.get(bytes);
        return bytes;
    }
}

