/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.util.Properties;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.util.Assert;

public class PropertiesBasedNamedQueries
implements NamedQueries {
    private static final String NO_QUERY_FOUND = "No query with name %s found! Make sure you call hasQuery(\u2026) before calling this method!";
    public static final NamedQueries EMPTY = new PropertiesBasedNamedQueries(new Properties());
    @NonNull
    private final Properties properties;

    @Override
    public boolean hasQuery(String queryName) {
        Assert.hasText(queryName, "Query name must not be null or empty!");
        return this.properties.containsKey(queryName);
    }

    @Override
    public String getQuery(String queryName) {
        Assert.hasText(queryName, "Query name must not be null or empty!");
        String query = this.properties.getProperty(queryName);
        if (query == null) {
            throw new IllegalArgumentException(String.format(NO_QUERY_FOUND, queryName));
        }
        return query;
    }

    @Generated
    public PropertiesBasedNamedQueries(@NonNull Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("properties is marked non-null but is null");
        }
        this.properties = properties;
    }
}

