/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.support;

import java.util.List;
import java.util.function.LongSupplier;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.Assert;

public final class PageableExecutionUtils {
    public static <T> Page<T> getPage(List<T> content, Pageable pageable, LongSupplier totalSupplier) {
        Assert.notNull(content, "Content must not be null!");
        Assert.notNull((Object)pageable, "Pageable must not be null!");
        Assert.notNull((Object)totalSupplier, "TotalSupplier must not be null!");
        if (pageable.isUnpaged() || pageable.getOffset() == 0L) {
            if (pageable.isUnpaged() || pageable.getPageSize() > content.size()) {
                return new PageImpl<T>(content, pageable, content.size());
            }
            return new PageImpl<T>(content, pageable, totalSupplier.getAsLong());
        }
        if (content.size() != 0 && pageable.getPageSize() > content.size()) {
            return new PageImpl<T>(content, pageable, pageable.getOffset() + (long)content.size());
        }
        return new PageImpl<T>(content, pageable, totalSupplier.getAsLong());
    }

    @Generated
    private PageableExecutionUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

