/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.reactive;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.springframework.lang.Nullable;
import org.springframework.transaction.reactive.TransactionSynchronization;
import org.springframework.util.StringUtils;

public class TransactionContext {
    @Nullable
    private final TransactionContext parent;
    private final UUID contextId = UUID.randomUUID();
    private final Map<Object, Object> resources = new LinkedHashMap<Object, Object>();
    @Nullable
    private Set<TransactionSynchronization> synchronizations;
    @Nullable
    private volatile String currentTransactionName;
    private volatile boolean currentTransactionReadOnly;
    @Nullable
    private volatile Integer currentTransactionIsolationLevel;
    private volatile boolean actualTransactionActive;

    TransactionContext() {
        this(null);
    }

    TransactionContext(@Nullable TransactionContext parent) {
        this.parent = parent;
    }

    @Nullable
    public TransactionContext getParent() {
        return this.parent;
    }

    public String getName() {
        if (StringUtils.hasText(this.currentTransactionName)) {
            return this.contextId + ": " + this.currentTransactionName;
        }
        return this.contextId.toString();
    }

    public UUID getContextId() {
        return this.contextId;
    }

    public Map<Object, Object> getResources() {
        return this.resources;
    }

    public void setSynchronizations(@Nullable Set<TransactionSynchronization> synchronizations) {
        this.synchronizations = synchronizations;
    }

    @Nullable
    public Set<TransactionSynchronization> getSynchronizations() {
        return this.synchronizations;
    }

    public void setCurrentTransactionName(@Nullable String currentTransactionName) {
        this.currentTransactionName = currentTransactionName;
    }

    @Nullable
    public String getCurrentTransactionName() {
        return this.currentTransactionName;
    }

    public void setCurrentTransactionReadOnly(boolean currentTransactionReadOnly) {
        this.currentTransactionReadOnly = currentTransactionReadOnly;
    }

    public boolean isCurrentTransactionReadOnly() {
        return this.currentTransactionReadOnly;
    }

    public void setCurrentTransactionIsolationLevel(@Nullable Integer currentTransactionIsolationLevel) {
        this.currentTransactionIsolationLevel = currentTransactionIsolationLevel;
    }

    @Nullable
    public Integer getCurrentTransactionIsolationLevel() {
        return this.currentTransactionIsolationLevel;
    }

    public void setActualTransactionActive(boolean actualTransactionActive) {
        this.actualTransactionActive = actualTransactionActive;
    }

    public boolean isActualTransactionActive() {
        return this.actualTransactionActive;
    }

    public void clear() {
        this.synchronizations = null;
        this.currentTransactionName = null;
        this.currentTransactionReadOnly = false;
        this.currentTransactionIsolationLevel = null;
        this.actualTransactionActive = false;
    }
}

