/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs.frame;

import org.springframework.util.Assert;
import org.springframework.web.socket.sockjs.frame.SockJsMessageCodec;

public abstract class AbstractSockJsMessageCodec
implements SockJsMessageCodec {
    @Override
    public String encode(String ... messages) {
        Assert.notNull((Object)messages, "messages must not be null");
        StringBuilder sb = new StringBuilder();
        sb.append("a[");
        for (int i2 = 0; i2 < messages.length; ++i2) {
            sb.append('\"');
            char[] quotedChars = this.applyJsonQuoting(messages[i2]);
            sb.append(this.escapeSockJsSpecialChars(quotedChars));
            sb.append('\"');
            if (i2 >= messages.length - 1) continue;
            sb.append(',');
        }
        sb.append(']');
        return sb.toString();
    }

    protected abstract char[] applyJsonQuoting(String var1);

    private String escapeSockJsSpecialChars(char[] characters) {
        StringBuilder result = new StringBuilder();
        for (char c : characters) {
            if (this.isSockJsSpecialChar(c)) {
                result.append('\\').append('u');
                String hex = Integer.toHexString(c).toLowerCase();
                for (int i2 = 0; i2 < 4 - hex.length(); ++i2) {
                    result.append('0');
                }
                result.append(hex);
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    private boolean isSockJsSpecialChar(char ch) {
        return ch <= '\u001f' || ch >= '\u200c' && ch <= '\u200f' || ch >= '\u2028' && ch <= '\u202f' || ch >= '\u2060' && ch <= '\u206f' || ch >= '\ufff0' || ch >= '\ud800' && ch <= '\udfff';
    }
}

