/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.math;

import cn.hutool.core.util.NumberUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Combination
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String[] datas;

    public Combination(String[] datas) {
        this.datas = datas;
    }

    public static long count(int n, int m) {
        if (0 == m) {
            return 1L;
        }
        if (n == m) {
            return NumberUtil.factorial(n) / NumberUtil.factorial(m);
        }
        return n > m ? NumberUtil.factorial(n, n - m) / NumberUtil.factorial(m) : 0L;
    }

    public static long countAll(int n) {
        long total = 0L;
        for (int i2 = 1; i2 <= n; ++i2) {
            total += Combination.count(n, i2);
        }
        return total;
    }

    public List<String[]> select(int m) {
        ArrayList<String[]> result = new ArrayList<String[]>((int)Combination.count(this.datas.length, m));
        this.select(0, new String[m], 0, result);
        return result;
    }

    public List<String[]> selectAll() {
        ArrayList<String[]> result = new ArrayList<String[]>((int)Combination.countAll(this.datas.length));
        for (int i2 = 1; i2 <= this.datas.length; ++i2) {
            result.addAll(this.select(i2));
        }
        return result;
    }

    private void select(int dataIndex, String[] resultList, int resultIndex, List<String[]> result) {
        int resultCount = resultIndex + 1;
        int resultLen = resultList.length;
        if (resultCount > resultLen) {
            result.add(Arrays.copyOf(resultList, resultList.length));
            return;
        }
        for (int i2 = dataIndex; i2 < this.datas.length + resultCount - resultLen; ++i2) {
            resultList[resultIndex] = this.datas[i2];
            this.select(i2 + 1, resultList, resultIndex + 1, result);
        }
    }
}

