/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.reactivestreams.Publisher;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactiveHyperLogLogCommands {
    default public Mono<Long> pfAdd(ByteBuffer key, ByteBuffer value) {
        Assert.notNull((Object)value, "Value must not be null!");
        return this.pfAdd(key, Collections.singletonList(value));
    }

    default public Mono<Long> pfAdd(ByteBuffer key, Collection<ByteBuffer> values) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull(values, "Values must not be null!");
        return this.pfAdd(Mono.just(PfAddCommand.values(values).to(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<PfAddCommand, Long>> pfAdd(Publisher<PfAddCommand> var1);

    default public Mono<Long> pfCount(ByteBuffer key) {
        Assert.notNull((Object)key, "Key must not be null!");
        return this.pfCount(Collections.singletonList(key));
    }

    default public Mono<Long> pfCount(Collection<ByteBuffer> keys) {
        Assert.notNull(keys, "Keys must not be null!");
        return this.pfCount(Mono.just(PfCountCommand.valuesIn(keys))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<PfCountCommand, Long>> pfCount(Publisher<PfCountCommand> var1);

    default public Mono<Boolean> pfMerge(ByteBuffer destinationKey, Collection<ByteBuffer> sourceKeys) {
        Assert.notNull((Object)destinationKey, "DestinationKey must not be null!");
        Assert.notNull(sourceKeys, "SourceKeys must not be null!");
        return this.pfMerge(Mono.just(PfMergeCommand.valuesIn(sourceKeys).into(destinationKey))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<PfMergeCommand>> pfMerge(Publisher<PfMergeCommand> var1);

    public static class PfMergeCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final List<ByteBuffer> sourceKeys;

        private PfMergeCommand(ByteBuffer key, List<ByteBuffer> sourceKeys) {
            super(key);
            this.sourceKeys = sourceKeys;
        }

        public static PfMergeCommand valuesIn(Collection<ByteBuffer> sourceKeys) {
            Assert.notNull(sourceKeys, "Source keys must not be null!");
            return new PfMergeCommand(null, new ArrayList<ByteBuffer>(sourceKeys));
        }

        public PfMergeCommand into(ByteBuffer destinationKey) {
            Assert.notNull((Object)destinationKey, "Destination key must not be null!");
            return new PfMergeCommand(destinationKey, this.sourceKeys);
        }

        public List<ByteBuffer> getSourceKeys() {
            return this.sourceKeys;
        }
    }

    public static class PfCountCommand
    implements ReactiveRedisConnection.Command {
        private final List<ByteBuffer> keys;

        private PfCountCommand(List<ByteBuffer> keys) {
            this.keys = keys;
        }

        public static PfCountCommand valueIn(ByteBuffer key) {
            Assert.notNull((Object)key, "Key must not be null!");
            return PfCountCommand.valuesIn(Collections.singletonList(key));
        }

        public static PfCountCommand valuesIn(Collection<ByteBuffer> keys) {
            Assert.notNull(keys, "Keys must not be null!");
            return new PfCountCommand(new ArrayList<ByteBuffer>(keys));
        }

        public List<ByteBuffer> getKeys() {
            return this.keys;
        }

        @Override
        public ByteBuffer getKey() {
            return null;
        }
    }

    public static class PfAddCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final List<ByteBuffer> values;

        private PfAddCommand(ByteBuffer key, List<ByteBuffer> values) {
            super(key);
            this.values = values;
        }

        public static PfAddCommand value(ByteBuffer value) {
            Assert.notNull((Object)value, "Value must not be null!");
            return PfAddCommand.values(Collections.singletonList(value));
        }

        public static PfAddCommand values(Collection<ByteBuffer> values) {
            Assert.notNull(values, "Values must not be null!");
            return new PfAddCommand(null, new ArrayList<ByteBuffer>(values));
        }

        public PfAddCommand to(ByteBuffer key) {
            Assert.notNull((Object)key, "Key must not be null!");
            return new PfAddCommand(key, this.values);
        }

        public List<ByteBuffer> getValues() {
            return this.values;
        }
    }
}

