/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.util.ReflectionUtils;
import redis.clients.jedis.Builder;
import redis.clients.jedis.Client;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.Queable;
import redis.clients.jedis.Response;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.util.SafeEncoder;

class JedisClientUtils {
    private static final Method GET_RESPONSE = ReflectionUtils.findMethod(Queable.class, "getResponse", Builder.class);
    private static final Set<String> KNOWN_COMMANDS;
    private static final Builder<Object> OBJECT_BUILDER;

    JedisClientUtils() {
    }

    static <T> T execute(String command, byte[][] keys, byte[][] args, Supplier<Jedis> jedis) {
        return (T)JedisClientUtils.execute(command, keys, args, jedis, it -> it.getOne());
    }

    static <T> T execute(String command, byte[][] keys, byte[][] args, Supplier<Jedis> jedis, Function<Client, T> responseMapper) {
        byte[][] commandArgs = JedisClientUtils.getCommandArguments(keys, args);
        Client client = JedisClientUtils.sendCommand(command, commandArgs, jedis.get());
        return responseMapper.apply(client);
    }

    static Client sendCommand(String command, byte[][] args, Jedis jedis) {
        Client client = jedis.getClient();
        JedisClientUtils.sendCommand(client, command, args);
        return client;
    }

    private static void sendCommand(Client client, String command, byte[][] args) {
        if (JedisClientUtils.isKnownCommand(command)) {
            client.sendCommand((ProtocolCommand)Protocol.Command.valueOf(command.trim().toUpperCase()), args);
        } else {
            client.sendCommand(() -> SafeEncoder.encode(command.trim().toUpperCase()), args);
        }
    }

    private static boolean isKnownCommand(String command) {
        return KNOWN_COMMANDS.contains(command);
    }

    private static byte[][] getCommandArguments(byte[][] keys, byte[][] args) {
        if (keys.length == 0) {
            return args;
        }
        if (args.length == 0) {
            return keys;
        }
        byte[][] commandArgs = new byte[keys.length + args.length][];
        System.arraycopy(keys, 0, commandArgs, 0, keys.length);
        System.arraycopy(args, 0, commandArgs, keys.length, args.length);
        return commandArgs;
    }

    static boolean isInMulti(Jedis jedis) {
        return jedis.getClient().isInMulti();
    }

    static Response<Object> getResponse(Object target) {
        return (Response)ReflectionUtils.invokeMethod(GET_RESPONSE, target, OBJECT_BUILDER);
    }

    static {
        ReflectionUtils.makeAccessible(GET_RESPONSE);
        KNOWN_COMMANDS = Arrays.stream(Protocol.Command.values()).map(Enum::name).collect(Collectors.toSet());
        OBJECT_BUILDER = new Builder<Object>(){

            @Override
            public Object build(Object data) {
                return data;
            }

            public String toString() {
                return "Object";
            }
        };
    }
}

