/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.function.Supplier;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.Nullable;

public abstract class FutureResult<T> {
    private T resultHolder;
    private final Supplier<?> defaultConversionResult;
    private boolean status = false;
    protected Converter converter;

    public FutureResult(T resultHolder) {
        this(resultHolder, val2 -> val2);
    }

    public FutureResult(T resultHolder, @Nullable Converter converter) {
        this(resultHolder, converter, () -> null);
    }

    public FutureResult(T resultHolder, @Nullable Converter converter, Supplier<?> defaultConversionResult) {
        this.resultHolder = resultHolder;
        this.converter = converter != null ? converter : val2 -> val2;
        this.defaultConversionResult = defaultConversionResult;
    }

    public T getResultHolder() {
        return this.resultHolder;
    }

    @Nullable
    public Object convert(@Nullable Object result) {
        if (result == null) {
            return this.computeDefaultResult(null);
        }
        return this.computeDefaultResult(this.converter.convert(result));
    }

    @Nullable
    private Object computeDefaultResult(@Nullable Object source) {
        return source != null ? source : this.defaultConversionResult.get();
    }

    public Converter getConverter() {
        return this.converter;
    }

    public boolean isStatus() {
        return this.status;
    }

    public void setStatus(boolean status) {
        this.status = status;
    }

    @Nullable
    public abstract Object get();

    public abstract boolean conversionRequired();
}

