/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.core;

import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.client.naming.utils.Chooser;
import com.alibaba.nacos.client.naming.utils.CollectionUtils;
import com.alibaba.nacos.client.naming.utils.Pair;
import com.alibaba.nacos.client.utils.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class Balancer {
    public static final List<String> UNCONSISTENT_SERVICE_WITH_ADDRESS_SERVER = new CopyOnWriteArrayList<String>();

    protected static Instance getHostByRandomWeight(List<Instance> hosts) {
        LogUtils.NAMING_LOGGER.debug("entry randomWithWeight");
        if (hosts == null || hosts.size() == 0) {
            LogUtils.NAMING_LOGGER.debug("hosts == null || hosts.size() == 0");
            return null;
        }
        Chooser vipChooser = new Chooser("www.taobao.com");
        LogUtils.NAMING_LOGGER.debug("new Chooser");
        ArrayList hostsWithWeight = new ArrayList();
        for (Instance host : hosts) {
            if (!host.isHealthy()) continue;
            hostsWithWeight.add(new Pair<Instance>(host, host.getWeight()));
        }
        LogUtils.NAMING_LOGGER.debug("for (Host host : hosts)");
        vipChooser.refresh(hostsWithWeight);
        LogUtils.NAMING_LOGGER.debug("vipChooser.refresh");
        return (Instance)vipChooser.randomWithWeight();
    }

    public static class RandomByWeight {
        public static List<Instance> selectAll(ServiceInfo serviceInfo) {
            List<Instance> hosts = serviceInfo.getHosts();
            if (CollectionUtils.isEmpty(hosts)) {
                throw new IllegalStateException("no host to srv for serviceInfo: " + serviceInfo.getName());
            }
            return hosts;
        }

        public static Instance selectHost(ServiceInfo dom) {
            List<Instance> hosts = RandomByWeight.selectAll(dom);
            if (CollectionUtils.isEmpty(hosts)) {
                throw new IllegalStateException("no host to srv for service: " + dom.getName());
            }
            return Balancer.getHostByRandomWeight(hosts);
        }
    }
}

