/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.support.atomic;

import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.BoundKeyOperations;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.serializer.GenericToStringSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.support.atomic.CompareAndSet;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class RedisAtomicDouble
extends Number
implements Serializable,
BoundKeyOperations<String> {
    private static final long serialVersionUID = 1L;
    private volatile String key;
    private final ValueOperations<String, Double> operations;
    private final RedisOperations<String, Double> generalOps;

    public RedisAtomicDouble(String redisCounter, RedisConnectionFactory factory) {
        this(redisCounter, factory, null);
    }

    public RedisAtomicDouble(String redisCounter, RedisConnectionFactory factory, double initialValue) {
        this(redisCounter, factory, (Double)initialValue);
    }

    private RedisAtomicDouble(String redisCounter, RedisConnectionFactory factory, @Nullable Double initialValue) {
        Assert.hasText(redisCounter, "a valid counter name is required");
        Assert.notNull((Object)factory, "a valid factory is required");
        RedisTemplate<String, Double> redisTemplate = new RedisTemplate<String, Double>();
        redisTemplate.setKeySerializer(RedisSerializer.string());
        redisTemplate.setValueSerializer(new GenericToStringSerializer<Double>(Double.class));
        redisTemplate.setExposeConnection(true);
        redisTemplate.setConnectionFactory(factory);
        redisTemplate.afterPropertiesSet();
        this.key = redisCounter;
        this.generalOps = redisTemplate;
        this.operations = this.generalOps.opsForValue();
        if (initialValue == null) {
            this.initializeIfAbsent();
        } else {
            this.set(initialValue);
        }
    }

    public RedisAtomicDouble(String redisCounter, RedisOperations<String, Double> template) {
        this(redisCounter, template, null);
    }

    public RedisAtomicDouble(String redisCounter, RedisOperations<String, Double> template, double initialValue) {
        this(redisCounter, template, (Double)initialValue);
    }

    private RedisAtomicDouble(String redisCounter, RedisOperations<String, Double> template, @Nullable Double initialValue) {
        Assert.hasText(redisCounter, "a valid counter name is required");
        Assert.notNull(template, "a valid template is required");
        Assert.notNull(template.getKeySerializer(), "a valid key serializer in template is required");
        Assert.notNull(template.getValueSerializer(), "a valid value serializer in template is required");
        this.key = redisCounter;
        this.generalOps = template;
        this.operations = this.generalOps.opsForValue();
        if (initialValue == null) {
            this.initializeIfAbsent();
        } else {
            this.set(initialValue);
        }
    }

    private void initializeIfAbsent() {
        this.operations.setIfAbsent(this.key, 0.0);
    }

    public double get() {
        Double value = this.operations.get(this.key);
        if (value != null) {
            return value;
        }
        throw new DataRetrievalFailureException(String.format("The key '%s' seems to no longer exist.", this.key));
    }

    public void set(double newValue) {
        this.operations.set(this.key, newValue);
    }

    public double getAndSet(double newValue) {
        Double value = this.operations.getAndSet(this.key, newValue);
        return value != null ? value : 0.0;
    }

    public boolean compareAndSet(double expect, double update) {
        return this.generalOps.execute(new CompareAndSet<Double>(this::get, this::set, this.key, expect, update));
    }

    public double getAndIncrement() {
        return this.incrementAndGet() - 1.0;
    }

    public double getAndDecrement() {
        return this.decrementAndGet() + 1.0;
    }

    public double getAndAdd(double delta) {
        return this.addAndGet(delta) - delta;
    }

    public double getAndUpdate(DoubleUnaryOperator updateFunction) {
        double newValue;
        double previousValue;
        Assert.notNull((Object)updateFunction, "Update function must not be null!");
        while (!this.compareAndSet(previousValue = this.get(), newValue = updateFunction.applyAsDouble(previousValue))) {
        }
        return previousValue;
    }

    public double getAndAccumulate(double updateValue, DoubleBinaryOperator accumulatorFunction) {
        double newValue;
        double previousValue;
        Assert.notNull((Object)accumulatorFunction, "Accumulator function must not be null!");
        while (!this.compareAndSet(previousValue = this.get(), newValue = accumulatorFunction.applyAsDouble(previousValue, updateValue))) {
        }
        return previousValue;
    }

    public double incrementAndGet() {
        return this.operations.increment(this.key, 1.0);
    }

    public double decrementAndGet() {
        return this.operations.increment(this.key, -1.0);
    }

    public double addAndGet(double delta) {
        return this.operations.increment(this.key, delta);
    }

    public double updateAndGet(DoubleUnaryOperator updateFunction) {
        double newValue;
        double previousValue;
        Assert.notNull((Object)updateFunction, "Update function must not be null!");
        while (!this.compareAndSet(previousValue = this.get(), newValue = updateFunction.applyAsDouble(previousValue))) {
        }
        return newValue;
    }

    public double accumulateAndGet(double updateValue, DoubleBinaryOperator accumulatorFunction) {
        double newValue;
        double previousValue;
        Assert.notNull((Object)accumulatorFunction, "Accumulator function must not be null!");
        while (!this.compareAndSet(previousValue = this.get(), newValue = accumulatorFunction.applyAsDouble(previousValue, updateValue))) {
        }
        return newValue;
    }

    public String toString() {
        return Double.toString(this.get());
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public DataType getType() {
        return DataType.STRING;
    }

    @Override
    public Long getExpire() {
        return this.generalOps.getExpire(this.key);
    }

    @Override
    public Boolean expire(long timeout, TimeUnit unit) {
        return this.generalOps.expire(this.key, timeout, unit);
    }

    @Override
    public Boolean expireAt(Date date) {
        return this.generalOps.expireAt(this.key, date);
    }

    @Override
    public Boolean persist() {
        return this.generalOps.persist(this.key);
    }

    @Override
    public void rename(String newKey) {
        this.generalOps.rename(this.key, newKey);
        this.key = newKey;
    }

    @Override
    public int intValue() {
        return (int)this.get();
    }

    @Override
    public long longValue() {
        return (long)this.get();
    }

    @Override
    public float floatValue() {
        return (float)this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }
}

