/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.Optional;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

public interface ValueEncoding {
    @Nullable
    public String raw();

    public static ValueEncoding of(@Nullable String encoding) {
        return RedisValueEncoding.lookup(encoding).orElse(() -> encoding);
    }

    public static enum RedisValueEncoding implements ValueEncoding
    {
        RAW("raw"),
        INT("int"),
        ZIPLIST("ziplist"),
        LINKEDLIST("linkedlist"),
        INTSET("intset"),
        HASHTABLE("hashtable"),
        SKIPLIST("skiplist"),
        VACANT(null);

        @Nullable
        private final String raw;

        private RedisValueEncoding(String raw) {
            this.raw = raw;
        }

        @Override
        public String raw() {
            return this.raw;
        }

        @Nullable
        static Optional<ValueEncoding> lookup(@Nullable String encoding) {
            for (RedisValueEncoding valueEncoding : RedisValueEncoding.values()) {
                if (!ObjectUtils.nullSafeEquals(valueEncoding.raw(), encoding)) continue;
                return Optional.of(valueEncoding);
            }
            return Optional.empty();
        }
    }
}

