/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel;

import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.StyleSet;
import cn.hutool.poi.excel.cell.CellEditor;
import cn.hutool.poi.excel.cell.CellUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class RowUtil {
    public static Row getOrCreateRow(Sheet sheet, int rowIndex) {
        Row row = sheet.getRow(rowIndex);
        if (null == row) {
            row = sheet.createRow(rowIndex);
        }
        return row;
    }

    public static List<Object> readRow(Row row, CellEditor cellEditor) {
        if (null == row) {
            return new ArrayList<Object>(0);
        }
        short length = row.getLastCellNum();
        if (length < 0) {
            return new ArrayList<Object>(0);
        }
        ArrayList<Object> cellValues = new ArrayList<Object>(length);
        boolean isAllNull = true;
        for (short i2 = 0; i2 < length; i2 = (short)(i2 + 1)) {
            Object cellValue = CellUtil.getCellValue(row.getCell((int)i2), cellEditor);
            isAllNull &= StrUtil.isEmptyIfStr(cellValue);
            cellValues.add(cellValue);
        }
        if (isAllNull) {
            return new ArrayList<Object>(0);
        }
        return cellValues;
    }

    public static void writeRow(Row row, Iterable<?> rowData, StyleSet styleSet, boolean isHeader) {
        int i2 = 0;
        for (Object value : rowData) {
            Cell cell = row.createCell(i2);
            CellUtil.setCellValue(cell, value, styleSet, isHeader);
            ++i2;
        }
    }
}

