/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.dynamic.parameter;

import io.lettuce.core.dynamic.batch.CommandBatching;
import io.lettuce.core.dynamic.domain.Timeout;
import io.lettuce.core.dynamic.parameter.Parameter;
import io.lettuce.core.dynamic.parameter.Parameters;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;

public class ExecutionSpecificParameters
extends Parameters<ExecutionAwareParameter> {
    private static final List<Class<?>> TYPES = Arrays.asList(Timeout.class, CommandBatching.class);
    private final int timeoutIndex;
    private final int commandBatchingIndex;

    public ExecutionSpecificParameters(Method method) {
        super(method);
        int timeoutIndex = -1;
        int commandBatchingIndex = -1;
        List parameters = this.getParameters();
        for (int i2 = 0; i2 < method.getParameterCount(); ++i2) {
            Parameter methodParameter = (Parameter)parameters.get(i2);
            if (!methodParameter.isSpecialParameter()) continue;
            if (methodParameter.isAssignableTo(Timeout.class)) {
                timeoutIndex = i2;
            }
            if (!methodParameter.isAssignableTo(CommandBatching.class)) continue;
            commandBatchingIndex = i2;
        }
        this.timeoutIndex = timeoutIndex;
        this.commandBatchingIndex = commandBatchingIndex;
    }

    public int getTimeoutIndex() {
        return this.timeoutIndex;
    }

    public int getCommandBatchingIndex() {
        return this.commandBatchingIndex;
    }

    @Override
    protected ExecutionAwareParameter createParameter(Method method, int parameterIndex) {
        return new ExecutionAwareParameter(method, parameterIndex);
    }

    public boolean hasCommandBatchingIndex() {
        return this.commandBatchingIndex != -1;
    }

    public boolean hasTimeoutIndex() {
        return this.getTimeoutIndex() != -1;
    }

    public static class ExecutionAwareParameter
    extends Parameter {
        public ExecutionAwareParameter(Method method, int parameterIndex) {
            super(method, parameterIndex);
        }

        @Override
        public boolean isSpecialParameter() {
            return super.isSpecialParameter() || TYPES.contains(this.getParameterType());
        }
    }
}

