/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.dispatcher.all;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.ExecutionException;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.exchange.Request;
import org.apache.dubbo.remoting.exchange.Response;
import org.apache.dubbo.remoting.transport.dispatcher.ChannelEventRunnable;
import org.apache.dubbo.remoting.transport.dispatcher.WrappedChannelHandler;

public class AllChannelHandler
extends WrappedChannelHandler {
    public AllChannelHandler(ChannelHandler handler, URL url) {
        super(handler, url);
    }

    @Override
    public void connected(Channel channel) throws RemotingException {
        ExecutorService executor = this.getExecutorService();
        try {
            executor.execute(new ChannelEventRunnable(channel, this.handler, ChannelEventRunnable.ChannelState.CONNECTED));
        }
        catch (Throwable t) {
            throw new ExecutionException((Object)"connect event", channel, this.getClass() + " error when process connected event .", t);
        }
    }

    @Override
    public void disconnected(Channel channel) throws RemotingException {
        ExecutorService executor = this.getExecutorService();
        try {
            executor.execute(new ChannelEventRunnable(channel, this.handler, ChannelEventRunnable.ChannelState.DISCONNECTED));
        }
        catch (Throwable t) {
            throw new ExecutionException((Object)"disconnect event", channel, this.getClass() + " error when process disconnected event .", t);
        }
    }

    @Override
    public void received(Channel channel, Object message) throws RemotingException {
        ExecutorService executor = this.getExecutorService();
        try {
            executor.execute(new ChannelEventRunnable(channel, this.handler, ChannelEventRunnable.ChannelState.RECEIVED, message));
        }
        catch (Throwable t) {
            Request request;
            if (message instanceof Request && t instanceof RejectedExecutionException && (request = (Request)message).isTwoWay()) {
                String msg = "Server side(" + this.url.getIp() + "," + this.url.getPort() + ") threadpool is exhausted ,detail msg:" + t.getMessage();
                Response response = new Response(request.getId(), request.getVersion());
                response.setStatus((byte)100);
                response.setErrorMessage(msg);
                channel.send(response);
                return;
            }
            throw new ExecutionException(message, channel, this.getClass() + " error when process received event .", t);
        }
    }

    @Override
    public void caught(Channel channel, Throwable exception) throws RemotingException {
        ExecutorService executor = this.getExecutorService();
        try {
            executor.execute(new ChannelEventRunnable(channel, this.handler, ChannelEventRunnable.ChannelState.CAUGHT, exception));
        }
        catch (Throwable t) {
            throw new ExecutionException((Object)"caught event", channel, this.getClass() + " error when process caught event .", t);
        }
    }
}

