/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.auditing;

import java.time.temporal.TemporalAccessor;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.auditing.AuditableBeanWrapper;
import org.springframework.data.auditing.CurrentDateTimeProvider;
import org.springframework.data.auditing.DateTimeProvider;
import org.springframework.data.auditing.DefaultAuditableBeanWrapperFactory;
import org.springframework.data.auditing.MappingAuditableBeanWrapperFactory;
import org.springframework.data.domain.AuditorAware;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.util.Assert;

public class AuditingHandler
implements InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditingHandler.class);
    private final DefaultAuditableBeanWrapperFactory factory;
    private DateTimeProvider dateTimeProvider = CurrentDateTimeProvider.INSTANCE;
    private Optional<AuditorAware<?>> auditorAware;
    private boolean dateTimeForNow = true;
    private boolean modifyOnCreation = true;

    @Deprecated
    public AuditingHandler(MappingContext<? extends PersistentEntity<?, ?>, ? extends PersistentProperty<?>> mappingContext) {
        this(PersistentEntities.of(mappingContext));
    }

    public AuditingHandler(PersistentEntities entities) {
        Assert.notNull((Object)entities, "PersistentEntities must not be null!");
        this.factory = new MappingAuditableBeanWrapperFactory(entities);
        this.auditorAware = Optional.empty();
    }

    public void setAuditorAware(AuditorAware<?> auditorAware) {
        Assert.notNull(auditorAware, "AuditorAware must not be null!");
        this.auditorAware = Optional.of(auditorAware);
    }

    public void setDateTimeForNow(boolean dateTimeForNow) {
        this.dateTimeForNow = dateTimeForNow;
    }

    public void setModifyOnCreation(boolean modifyOnCreation) {
        this.modifyOnCreation = modifyOnCreation;
    }

    public void setDateTimeProvider(DateTimeProvider dateTimeProvider) {
        this.dateTimeProvider = dateTimeProvider == null ? CurrentDateTimeProvider.INSTANCE : dateTimeProvider;
    }

    public <T> T markCreated(T source) {
        Assert.notNull(source, "Entity must not be null!");
        return this.touch(source, true);
    }

    public <T> T markModified(T source) {
        Assert.notNull(source, "Entity must not be null!");
        return this.touch(source, false);
    }

    protected final boolean isAuditable(Object source) {
        Assert.notNull(source, "Source must not be null!");
        return this.factory.getBeanWrapperFor(source).isPresent();
    }

    private <T> T touch(T target, boolean isNew) {
        Optional<AuditableBeanWrapper<AuditableBeanWrapper>> wrapper = this.factory.getBeanWrapperFor(target);
        return (T)wrapper.map(it -> {
            Optional<TemporalAccessor> now;
            Optional<Object> auditor = this.touchAuditor((AuditableBeanWrapper<?>)it, isNew);
            Optional<TemporalAccessor> optional = now = this.dateTimeForNow ? this.touchDate((AuditableBeanWrapper<?>)it, isNew) : Optional.empty();
            if (LOGGER.isDebugEnabled()) {
                String defaultedNow = now.map(Object::toString).orElse("not set");
                String defaultedAuditor = auditor.map(Object::toString).orElse("unknown");
                LOGGER.debug("Touched {} - Last modification at {} by {}", target, defaultedNow, defaultedAuditor);
            }
            return it.getBean();
        }).orElse(target);
    }

    private Optional<Object> touchAuditor(AuditableBeanWrapper<?> wrapper, boolean isNew) {
        Assert.notNull(wrapper, "AuditableBeanWrapper must not be null!");
        return this.auditorAware.map(it -> {
            Optional<Object> auditor = it.getCurrentAuditor();
            Assert.notNull(auditor, () -> String.format("Auditor must not be null! Returned by: %s!", AopUtils.getTargetClass(it)));
            auditor.filter(__ -> isNew).ifPresent(foo -> wrapper.setCreatedBy(foo));
            auditor.filter(__ -> !isNew || this.modifyOnCreation).ifPresent(foo -> wrapper.setLastModifiedBy(foo));
            return auditor;
        });
    }

    private Optional<TemporalAccessor> touchDate(AuditableBeanWrapper<?> wrapper, boolean isNew) {
        Assert.notNull(wrapper, "AuditableBeanWrapper must not be null!");
        Optional<TemporalAccessor> now = this.dateTimeProvider.getNow();
        Assert.notNull(now, () -> String.format("Now must not be null! Returned by: %s!", this.dateTimeProvider.getClass()));
        now.filter(__ -> isNew).ifPresent(it -> wrapper.setCreatedDate((TemporalAccessor)it));
        now.filter(__ -> !isNew || this.modifyOnCreation).ifPresent(it -> wrapper.setLastModifiedDate((TemporalAccessor)it));
        return now;
    }

    @Override
    public void afterPropertiesSet() {
        if (!this.auditorAware.isPresent()) {
            LOGGER.debug("No AuditorAware set! Auditing will not be applied!");
        }
    }
}

