/*
 * Decompiled with CFR 0.152.
 */
package com.mugui.sql.loader;

import com.mugui.bean.JsonBean;
import com.mugui.sql.JsonBeanAttr;
import com.mugui.sql.loader.Parameter;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class Update
extends Parameter {
    private static final long serialVersionUID = -7687091899204637392L;
    public static final int TYPE_BASE = 0;
    public static final int TYPE_INCREMENT = 1;

    public Update(JsonBean bean2, int type) {
        this.sql = new StringBuilder();
        switch (type) {
            case 0: {
                this.queryBase(bean2);
                break;
            }
            case 1: {
                this.queryIncrement(bean2);
                break;
            }
        }
    }

    private Update queryBase(JsonBean bean2) {
        Object value;
        JsonBeanAttr attr = JsonBeanAttr.getAttr(bean2);
        this.sql.append("UPDATE `").append(attr.getTABLE()).append("` SET ");
        int i2 = 1;
        List<Field> fields = attr.getFields();
        while (i2 < fields.size()) {
            try {
                value = fields.get(i2).get(bean2);
                if (value != null) {
                    this.sql.append("`").append(fields.get(i2).getName()).append("`=?");
                    ++i2;
                    this.addParameter(value);
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i2;
        }
        while (i2 < fields.size()) {
            try {
                value = fields.get(i2).get(bean2);
                if (value != null) {
                    this.sql.append(",`").append(fields.get(i2).getName()).append("`=?");
                    this.addParameter(value);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i2;
        }
        this.sql.append(" WHERE `").append(attr.getKEY()).append("`=? ");
        this.addParameter(bean2.get(attr.getKEY()));
        return this;
    }

    private Update queryIncrement(JsonBean bean2) {
        String sql;
        Object value;
        JsonBeanAttr attr = JsonBeanAttr.getAttr(bean2);
        this.sql.append("UPDATE `").append(attr.getTABLE()).append("` SET ");
        int i2 = 1;
        Field[] fields = attr.getFields().toArray(new Field[0]);
        ArrayList<Object> list = new ArrayList<Object>();
        while (i2 < fields.length) {
            try {
                value = fields[i2].get(bean2);
                if (value != null && (sql = this.handleFieldByIncrement(fields[i2], bean2, list)) != null) {
                    this.sql.append(sql);
                    ++i2;
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i2;
        }
        while (i2 < fields.length) {
            try {
                value = fields[i2].get(bean2);
                if (value != null && (sql = this.handleFieldByIncrement(fields[i2], bean2, list)) != null) {
                    this.sql.append(",").append(sql);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i2;
        }
        this.sql.append(" WHERE `").append(attr.getKEY()).append("`=? ");
        this.addParameter(bean2.get(attr.getKEY()));
        return this;
    }

    private String handleFieldByIncrement(Field fields, JsonBean bean2, ArrayList<Object> list) throws IllegalArgumentException, IllegalAccessException {
        if (fields.getType() == Integer.TYPE || fields.getType() == Integer.class) {
            if ((Integer)fields.get(bean2) == 0) {
                return null;
            }
            return "`" + fields.getName() + "`='" + fields.get(bean2).toString() + "'+" + "`" + fields.getName() + "`";
        }
        if (fields.getType() == BigDecimal.class) {
            if (((BigDecimal)fields.get(bean2)).compareTo(BigDecimal.ZERO) == 0) {
                return null;
            }
            return "`" + fields.getName() + "`='" + ((BigDecimal)fields.get(bean2)).setScale(8, 5) + "'+" + "`" + fields.getName() + "`";
        }
        Object object = fields.get(bean2);
        list.add(object);
        this.addParameter(object);
        return "`" + fields.getName() + "`=?";
    }

    public static Update q(JsonBean bean2) {
        return new Update(bean2, 0);
    }

    public static Update increment(JsonBean bean2) {
        return new Update(bean2, 1);
    }
}

