/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.core;

import java.util.Iterator;
import org.springframework.data.util.CloseableIterator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ForwardingCloseableIterator<T>
implements CloseableIterator<T> {
    private final Iterator<? extends T> delegate;
    @Nullable
    private final Runnable closeHandler;

    public ForwardingCloseableIterator(Iterator<? extends T> delegate) {
        this(delegate, null);
    }

    public ForwardingCloseableIterator(Iterator<? extends T> delegate, @Nullable Runnable closeHandler) {
        Assert.notNull(delegate, "Delegate iterator must not be null!");
        this.delegate = delegate;
        this.closeHandler = closeHandler;
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public T next() {
        return this.delegate.next();
    }

    @Override
    public void close() {
        if (this.closeHandler != null) {
            this.closeHandler.run();
        }
    }
}

