/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.BitFieldSubCommands;
import org.springframework.data.redis.connection.ClusterSlotHashUtil;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.jedis.JedisClusterConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.util.ByteUtils;
import org.springframework.util.Assert;
import redis.clients.jedis.BinaryJedis;
import redis.clients.jedis.Connection;
import redis.clients.jedis.params.SetParams;

class JedisClusterStringCommands
implements RedisStringCommands {
    @NonNull
    private final JedisClusterConnection connection;

    @Override
    public byte[] get(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            return this.connection.getCluster().get(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] getSet(byte[] key, byte[] value) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)value, "Value must not be null!");
        try {
            return this.connection.getCluster().getSet(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> mGet(byte[] ... keys) {
        Assert.notNull((Object)keys, "Keys must not be null!");
        Assert.noNullElements((Object[])keys, "Keys must not contain null elements!");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(keys)) {
            return this.connection.getCluster().mget(keys);
        }
        return this.connection.getClusterCommandExecutor().executeMultiKeyCommand(BinaryJedis::get, Arrays.asList(keys)).resultsAsListSortBy(keys);
    }

    @Override
    public Boolean set(byte[] key, byte[] value) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)value, "Value must not be null!");
        try {
            return Converters.stringToBoolean(this.connection.getCluster().set(key, value));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean set(byte[] key, byte[] value, Expiration expiration, RedisStringCommands.SetOption option) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)value, "Value must not be null!");
        Assert.notNull((Object)expiration, "Expiration must not be null!");
        Assert.notNull((Object)option, "Option must not be null!");
        SetParams setParams = JedisConverters.toSetCommandExPxArgument(expiration, JedisConverters.toSetCommandNxXxArgument(option));
        try {
            return Converters.stringToBoolean(this.connection.getCluster().set(key, value, setParams));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean setNX(byte[] key, byte[] value) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)value, "Value must not be null!");
        try {
            return JedisConverters.toBoolean(this.connection.getCluster().setnx(key, value));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean setEx(byte[] key, long seconds, byte[] value) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)value, "Value must not be null!");
        if (seconds > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Seconds have cannot exceed Integer.MAX_VALUE!");
        }
        try {
            return Converters.stringToBoolean(this.connection.getCluster().setex(key, Long.valueOf(seconds).intValue(), value));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean pSetEx(byte[] key, long milliseconds, byte[] value) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)value, "Value must not be null!");
        try {
            return Converters.stringToBoolean(this.connection.getCluster().psetex(key, milliseconds, value));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean mSet(Map<byte[], byte[]> tuples) {
        Assert.notNull(tuples, "Tuples must not be null!");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys((byte[][])tuples.keySet().toArray((T[])new byte[tuples.keySet().size()][]))) {
            try {
                return Converters.stringToBoolean(this.connection.getCluster().mset(JedisConverters.toByteArrays(tuples)));
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        boolean result = true;
        for (Map.Entry<byte[], byte[]> entry : tuples.entrySet()) {
            if (this.set(entry.getKey(), entry.getValue()).booleanValue()) continue;
            result = false;
        }
        return result;
    }

    @Override
    public Boolean mSetNX(Map<byte[], byte[]> tuples) {
        Assert.notNull(tuples, "Tuples must not be null!");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys((byte[][])tuples.keySet().toArray((T[])new byte[tuples.keySet().size()][]))) {
            try {
                return JedisConverters.toBoolean(this.connection.getCluster().msetnx(JedisConverters.toByteArrays(tuples)));
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        boolean result = true;
        for (Map.Entry<byte[], byte[]> entry : tuples.entrySet()) {
            if (this.setNX(entry.getKey(), entry.getValue()).booleanValue() || !result) continue;
            result = false;
        }
        return result;
    }

    @Override
    public Long incr(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            return this.connection.getCluster().incr(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long incrBy(byte[] key, long value) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            return this.connection.getCluster().incrBy(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Double incrBy(byte[] key, double value) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            return this.connection.getCluster().incrByFloat(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long decr(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            return this.connection.getCluster().decr(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long decrBy(byte[] key, long value) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            return this.connection.getCluster().decrBy(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long append(byte[] key, byte[] value) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)value, "Value must not be null!");
        try {
            return this.connection.getCluster().append(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] getRange(byte[] key, long start, long end) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            return this.connection.getCluster().getrange(key, start, end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void setRange(byte[] key, byte[] value, long offset) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)value, "Value must not be null!");
        try {
            this.connection.getCluster().setrange(key, offset, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean getBit(byte[] key, long offset) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            return this.connection.getCluster().getbit(key, offset);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean setBit(byte[] key, long offset, boolean value) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            return this.connection.getCluster().setbit(key, offset, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long bitCount(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            return this.connection.getCluster().bitcount(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long bitCount(byte[] key, long start, long end) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            return this.connection.getCluster().bitcount(key, start, end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<Long> bitField(byte[] key, BitFieldSubCommands subCommands) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)subCommands, "Command must not be null!");
        byte[][] args = JedisConverters.toBitfieldCommandArguments(subCommands);
        try {
            return this.connection.execute("BITFIELD", key, Arrays.asList(args), Connection::getIntegerMultiBulkReply);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long bitOp(RedisStringCommands.BitOperation op, byte[] destination, byte[] ... keys) {
        Assert.notNull((Object)op, "BitOperation must not be null!");
        Assert.notNull((Object)destination, "Destination key must not be null!");
        byte[][] allKeys = ByteUtils.mergeArrays(destination, keys);
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(allKeys)) {
            try {
                return this.connection.getCluster().bitop(JedisConverters.toBitOp(op), destination, keys);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        throw new InvalidDataAccessApiUsageException("BITOP is only supported for same slot keys in cluster mode.");
    }

    @Override
    public Long bitPos(byte[] key, boolean bit, Range<Long> range) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull(range, "Range must not be null! Use Range.unbounded() instead.");
        ArrayList<byte[]> args = new ArrayList<byte[]>(3);
        args.add(LettuceConverters.toBit(bit));
        if (range.getLowerBound().isBounded()) {
            args.add(range.getLowerBound().getValue().map(LettuceConverters::toBytes).get());
        }
        if (range.getUpperBound().isBounded()) {
            args.add(range.getUpperBound().getValue().map(LettuceConverters::toBytes).get());
        }
        return (Long)Long.class.cast(this.connection.execute("BITPOS", key, args));
    }

    @Override
    public Long strLen(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            return this.connection.getCluster().strlen(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    private DataAccessException convertJedisAccessException(Exception ex) {
        return this.connection.convertJedisAccessException(ex);
    }

    public JedisClusterStringCommands(@NonNull JedisClusterConnection connection) {
        if (connection == null) {
            throw new NullPointerException("connection is marked non-null but is null");
        }
        this.connection = connection;
    }
}

