/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.core.session.SessionInformation;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.Session;
import org.springframework.session.security.SpringSessionBackedSessionInformation;
import org.springframework.util.Assert;

public class SpringSessionBackedSessionRegistry<S extends Session>
implements SessionRegistry {
    private final FindByIndexNameSessionRepository<S> sessionRepository;

    public SpringSessionBackedSessionRegistry(FindByIndexNameSessionRepository<S> sessionRepository) {
        Assert.notNull(sessionRepository, "sessionRepository cannot be null");
        this.sessionRepository = sessionRepository;
    }

    public List<Object> getAllPrincipals() {
        throw new UnsupportedOperationException("SpringSessionBackedSessionRegistry does not support retrieving all principals, since Spring Session provides no way to obtain that information");
    }

    public List<SessionInformation> getAllSessions(Object principal, boolean includeExpiredSessions) {
        Collection<S> sessions = this.sessionRepository.findByPrincipalName(this.name(principal)).values();
        ArrayList<SessionInformation> infos = new ArrayList<SessionInformation>();
        for (Session session : sessions) {
            if (!includeExpiredSessions && Boolean.TRUE.equals(session.getAttribute(SpringSessionBackedSessionInformation.EXPIRED_ATTR))) continue;
            infos.add(new SpringSessionBackedSessionInformation<Session>(session, this.sessionRepository));
        }
        return infos;
    }

    public SessionInformation getSessionInformation(String sessionId) {
        Object session = this.sessionRepository.findById(sessionId);
        if (session != null) {
            return new SpringSessionBackedSessionInformation(session, this.sessionRepository);
        }
        return null;
    }

    public void refreshLastRequest(String sessionId) {
    }

    public void registerNewSession(String sessionId, Object principal) {
    }

    public void removeSessionInformation(String sessionId) {
    }

    protected String name(Object principal) {
        return new TestingAuthenticationToken(principal, null).getName();
    }
}

