/*
 * Decompiled with CFR 0.152.
 */
package com.mugui.spring.util;

import com.mugui.util.Other;
import java.time.Duration;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisClientConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;
import redis.clients.jedis.JedisPoolConfig;

@Component
public class RedisAccess {
    private String REDISTHOST = null;
    private int REDISPORT;
    private String REDISPASSWORD = null;
    @Autowired
    private Environment env;
    public static ThreadLocal<HashMap<Integer, StringRedisTemplate>> threadlocal = new ThreadLocal();

    private StringRedisTemplate redisTemplate(RedisConnectionFactory redisConnectionFactory) {
        StringRedisTemplate template = new StringRedisTemplate();
        template.setConnectionFactory(redisConnectionFactory);
        template.afterPropertiesSet();
        return template;
    }

    public RedisConnectionFactory createRedisFactory(int select) {
        if (StringUtils.isBlank(this.REDISTHOST)) {
            this.REDISTHOST = this.env.getProperty("spring.redis.host");
            this.REDISPORT = Integer.parseInt(this.env.getProperty("spring.redis.port"));
            this.REDISPASSWORD = this.env.getProperty("spring.redis.password");
        }
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxTotal(20);
        poolConfig.setMaxIdle(20);
        poolConfig.setMaxWaitMillis(10000L);
        poolConfig.setMinIdle(10);
        poolConfig.setTestOnBorrow(true);
        poolConfig.setTestOnReturn(false);
        poolConfig.setTimeBetweenEvictionRunsMillis(10000L);
        poolConfig.setTestOnCreate(true);
        poolConfig.setMinEvictableIdleTimeMillis(5000L);
        poolConfig.setTestWhileIdle(true);
        JedisClientConfiguration clientConfig = JedisClientConfiguration.builder().usePooling().poolConfig(poolConfig).and().readTimeout(Duration.ofMillis(10000L)).build();
        RedisStandaloneConfiguration redisConfig = new RedisStandaloneConfiguration();
        redisConfig.setHostName(this.REDISTHOST);
        if (StringUtils.isNotBlank(this.REDISPASSWORD)) {
            redisConfig.setPassword(RedisPassword.of(this.REDISPASSWORD));
        }
        redisConfig.setPort(this.REDISPORT);
        redisConfig.setDatabase(select);
        return new JedisConnectionFactory(redisConfig, clientConfig);
    }

    public StringRedisTemplate getRedisClient() {
        return this.getRedisClient(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringRedisTemplate getRedisClient(int i2) {
        StringRedisTemplate stringRedisTemplate;
        HashMap<Integer, StringRedisTemplate> hashMap = threadlocal.get();
        if (hashMap == null) {
            ThreadLocal<HashMap<Integer, StringRedisTemplate>> threadLocal = threadlocal;
            synchronized (threadLocal) {
                hashMap = threadlocal.get();
                if (hashMap == null) {
                    hashMap = new HashMap();
                    threadlocal.set(hashMap);
                }
            }
        }
        if ((stringRedisTemplate = hashMap.get(i2)) != null) {
            try {
                stringRedisTemplate.opsForValue().get("mugui=StringRedisTemplate");
            }
            catch (Exception e) {
                stringRedisTemplate = null;
                hashMap.remove(i2);
            }
        }
        if (stringRedisTemplate == null) {
            RedisConnectionFactory createRedisFactory = this.createRedisFactory(i2);
            while (true) {
                try {
                    stringRedisTemplate = this.redisTemplate(createRedisFactory);
                    stringRedisTemplate.getConnectionFactory().getConnection().time();
                    hashMap.put(i2, stringRedisTemplate);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Other.sleep(5000);
                    continue;
                }
                break;
            }
        }
        return stringRedisTemplate;
    }

    public void push(String key, String bean2) {
        StringRedisTemplate jedis = null;
        jedis = this.getRedisClient();
        jedis.opsForList().rightPush(key, bean2.toString());
    }

    public String pop(String key) {
        StringRedisTemplate jedis = null;
        jedis = this.getRedisClient();
        return (String)jedis.opsForList().leftPop(key);
    }

    public String get(String key) {
        StringRedisTemplate jedis = null;
        jedis = this.getRedisClient();
        return (String)jedis.opsForValue().get(key);
    }

    public void set(String key, String bean2) {
        StringRedisTemplate jedis = null;
        jedis = this.getRedisClient();
        jedis.opsForValue().set(key, bean2);
    }

    public void del(String key) {
    }
}

