/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ConfigCenterConfig;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.MetadataReportConfig;
import org.apache.dubbo.config.MetricsConfig;
import org.apache.dubbo.config.ModuleConfig;
import org.apache.dubbo.config.MonitorConfig;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.dubbo.config.spring.ConfigCenterBean;
import org.apache.dubbo.config.spring.extension.SpringExtensionFactory;
import org.apache.dubbo.config.support.Parameter;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ReferenceBean<T>
extends ReferenceConfig<T>
implements FactoryBean,
ApplicationContextAware,
InitializingBean,
DisposableBean {
    private static final long serialVersionUID = 213195494150089726L;
    private transient ApplicationContext applicationContext;

    public ReferenceBean() {
    }

    public ReferenceBean(Reference reference) {
        super(reference);
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        SpringExtensionFactory.addApplicationContext(applicationContext);
    }

    public Object getObject() {
        return this.get();
    }

    @Override
    public Class<?> getObjectType() {
        return this.getInterfaceClass();
    }

    @Override
    @Parameter(excluded=true)
    public boolean isSingleton() {
        return true;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.applicationContext != null) {
            BeanFactoryUtils.beansOfTypeIncludingAncestors(this.applicationContext, ConfigCenterBean.class, false, false);
        }
        if (this.getConsumer() == null) {
            Map<String, ConsumerConfig> consumerConfigMap;
            Map<String, ConsumerConfig> map = consumerConfigMap = this.applicationContext == null ? null : BeanFactoryUtils.beansOfTypeIncludingAncestors(this.applicationContext, ConsumerConfig.class, false, false);
            if (consumerConfigMap != null && consumerConfigMap.size() > 0) {
                ConsumerConfig consumerConfig = null;
                for (ConsumerConfig consumerConfig2 : consumerConfigMap.values()) {
                    if (consumerConfig2.isDefault() != null && !consumerConfig2.isDefault().booleanValue()) continue;
                    if (consumerConfig != null) {
                        throw new IllegalStateException("Duplicate consumer configs: " + consumerConfig + " and " + consumerConfig2);
                    }
                    consumerConfig = consumerConfig2;
                }
                if (consumerConfig != null) {
                    this.setConsumer(consumerConfig);
                }
            }
        }
        if (this.getApplication() == null && (this.getConsumer() == null || this.getConsumer().getApplication() == null)) {
            Map<String, ApplicationConfig> applicationConfigMap;
            Map<String, ApplicationConfig> map = applicationConfigMap = this.applicationContext == null ? null : BeanFactoryUtils.beansOfTypeIncludingAncestors(this.applicationContext, ApplicationConfig.class, false, false);
            if (applicationConfigMap != null && applicationConfigMap.size() > 0) {
                ApplicationConfig applicationConfig = null;
                for (ApplicationConfig applicationConfig2 : applicationConfigMap.values()) {
                    if (applicationConfig != null) {
                        throw new IllegalStateException("Duplicate application configs: " + applicationConfig + " and " + applicationConfig2);
                    }
                    applicationConfig = applicationConfig2;
                }
                if (applicationConfig != null) {
                    this.setApplication(applicationConfig);
                }
            }
        }
        if (this.getModule() == null && (this.getConsumer() == null || this.getConsumer().getModule() == null)) {
            Map<String, ModuleConfig> moduleConfigMap;
            Map<String, ModuleConfig> map = moduleConfigMap = this.applicationContext == null ? null : BeanFactoryUtils.beansOfTypeIncludingAncestors(this.applicationContext, ModuleConfig.class, false, false);
            if (moduleConfigMap != null && moduleConfigMap.size() > 0) {
                ModuleConfig moduleConfig = null;
                for (ModuleConfig moduleConfig2 : moduleConfigMap.values()) {
                    if (moduleConfig2.isDefault() != null && !moduleConfig2.isDefault().booleanValue()) continue;
                    if (moduleConfig != null) {
                        throw new IllegalStateException("Duplicate module configs: " + moduleConfig + " and " + moduleConfig2);
                    }
                    moduleConfig = moduleConfig2;
                }
                if (moduleConfig != null) {
                    this.setModule(moduleConfig);
                }
            }
        }
        if (StringUtils.isEmpty(this.getRegistryIds())) {
            if (this.getApplication() != null && StringUtils.isNotEmpty(this.getApplication().getRegistryIds())) {
                this.setRegistryIds(this.getApplication().getRegistryIds());
            }
            if (this.getConsumer() != null && StringUtils.isNotEmpty(this.getConsumer().getRegistryIds())) {
                this.setRegistryIds(this.getConsumer().getRegistryIds());
            }
        }
        if (CollectionUtils.isEmpty(this.getRegistries()) && (this.getConsumer() == null || CollectionUtils.isEmpty(this.getConsumer().getRegistries())) && (this.getApplication() == null || CollectionUtils.isEmpty(this.getApplication().getRegistries()))) {
            Map<String, RegistryConfig> registryConfigMap;
            Map<String, RegistryConfig> map = registryConfigMap = this.applicationContext == null ? null : BeanFactoryUtils.beansOfTypeIncludingAncestors(this.applicationContext, RegistryConfig.class, false, false);
            if (registryConfigMap != null && registryConfigMap.size() > 0) {
                ArrayList<RegistryConfig> registryConfigs = new ArrayList<RegistryConfig>();
                if (StringUtils.isNotEmpty(this.registryIds)) {
                    Arrays.stream(CommonConstants.COMMA_SPLIT_PATTERN.split(this.registryIds)).forEach(id -> {
                        if (registryConfigMap.containsKey(id)) {
                            registryConfigs.add((AbstractConfig)registryConfigMap.get(id));
                        }
                    });
                }
                if (registryConfigs.isEmpty()) {
                    for (RegistryConfig registryConfig : registryConfigMap.values()) {
                        if (!StringUtils.isEmpty(this.registryIds)) continue;
                        registryConfigs.add(registryConfig);
                    }
                }
                if (!registryConfigs.isEmpty()) {
                    super.setRegistries(registryConfigs);
                }
            }
        }
        if (this.getMetadataReportConfig() == null) {
            Map<String, MetadataReportConfig> metadataReportConfigMap;
            Map<String, MetadataReportConfig> map = metadataReportConfigMap = this.applicationContext == null ? null : BeanFactoryUtils.beansOfTypeIncludingAncestors(this.applicationContext, MetadataReportConfig.class, false, false);
            if (metadataReportConfigMap != null && metadataReportConfigMap.size() == 1) {
                super.setMetadataReportConfig(metadataReportConfigMap.values().iterator().next());
            } else if (metadataReportConfigMap != null && metadataReportConfigMap.size() > 1) {
                throw new IllegalStateException("Multiple MetadataReport configs: " + metadataReportConfigMap);
            }
        }
        if (this.getConfigCenter() == null) {
            Map<String, ConfigCenterConfig> configenterMap;
            Map<String, ConfigCenterConfig> map = configenterMap = this.applicationContext == null ? null : BeanFactoryUtils.beansOfTypeIncludingAncestors(this.applicationContext, ConfigCenterConfig.class, false, false);
            if (configenterMap != null && configenterMap.size() == 1) {
                super.setConfigCenter(configenterMap.values().iterator().next());
            } else if (configenterMap != null && configenterMap.size() > 1) {
                throw new IllegalStateException("Multiple ConfigCenter found:" + configenterMap);
            }
        }
        if (!(this.getMonitor() != null || this.getConsumer() != null && this.getConsumer().getMonitor() != null || this.getApplication() != null && this.getApplication().getMonitor() != null)) {
            Map<String, MonitorConfig> monitorConfigMap;
            Map<String, MonitorConfig> map = monitorConfigMap = this.applicationContext == null ? null : BeanFactoryUtils.beansOfTypeIncludingAncestors(this.applicationContext, MonitorConfig.class, false, false);
            if (monitorConfigMap != null && monitorConfigMap.size() > 0) {
                MonitorConfig monitorConfig = null;
                for (MonitorConfig monitorConfig2 : monitorConfigMap.values()) {
                    if (monitorConfig2.isDefault() != null && !monitorConfig2.isDefault().booleanValue()) continue;
                    if (monitorConfig != null) {
                        throw new IllegalStateException("Duplicate monitor configs: " + monitorConfig + " and " + monitorConfig2);
                    }
                    monitorConfig = monitorConfig2;
                }
                if (monitorConfig != null) {
                    this.setMonitor(monitorConfig);
                }
            }
        }
        if (this.getMetrics() == null) {
            Map<String, MetricsConfig> metricsConfigMap;
            Map<String, MetricsConfig> map = metricsConfigMap = this.applicationContext == null ? null : BeanFactoryUtils.beansOfTypeIncludingAncestors(this.applicationContext, MetricsConfig.class, false, false);
            if (metricsConfigMap != null && metricsConfigMap.size() > 0) {
                MetricsConfig metricsConfig = null;
                for (MetricsConfig metricsConfig2 : metricsConfigMap.values()) {
                    if (metricsConfig != null) {
                        throw new IllegalStateException("Duplicate metrics configs: " + metricsConfig + " and " + metricsConfig2);
                    }
                    metricsConfig = metricsConfig2;
                }
                if (metricsConfig != null) {
                    this.setMetrics(metricsConfig);
                }
            }
        }
        if (this.shouldInit()) {
            this.getObject();
        }
    }

    @Override
    public void destroy() {
    }
}

