/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.boot.util;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.ObjectUtils;

public abstract class EnvironmentUtils {
    public static Map<String, Object> extractProperties(ConfigurableEnvironment environment2) {
        return Collections.unmodifiableMap(EnvironmentUtils.doExtraProperties(environment2));
    }

    private static Map<String, Object> doExtraProperties(ConfigurableEnvironment environment2) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        Map<String, PropertySource<?>> map = EnvironmentUtils.doGetPropertySources(environment2);
        for (PropertySource<?> source : map.values()) {
            EnumerablePropertySource propertySource;
            Object[] propertyNames;
            if (!(source instanceof EnumerablePropertySource) || ObjectUtils.isEmpty(propertyNames = (propertySource = (EnumerablePropertySource)source).getPropertyNames())) continue;
            for (Object propertyName : propertyNames) {
                if (properties.containsKey(propertyName)) continue;
                properties.put((String)propertyName, propertySource.getProperty((String)propertyName));
            }
        }
        return properties;
    }

    private static Map<String, PropertySource<?>> doGetPropertySources(ConfigurableEnvironment environment2) {
        LinkedHashMap map = new LinkedHashMap();
        MutablePropertySources sources = environment2.getPropertySources();
        for (PropertySource<?> source : sources) {
            EnvironmentUtils.extract("", map, source);
        }
        return map;
    }

    private static void extract(String root, Map<String, PropertySource<?>> map, PropertySource<?> source) {
        if (source instanceof CompositePropertySource) {
            for (PropertySource<?> nest2 : ((CompositePropertySource)source).getPropertySources()) {
                EnvironmentUtils.extract(source.getName() + ":", map, nest2);
            }
        } else {
            map.put(root + source.getName(), source);
        }
    }
}

