/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.stream;

import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.Record;
import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.data.redis.hash.HashMapper;
import org.springframework.util.Assert;

public interface ObjectRecord<S, V>
extends Record<S, V> {
    public static <S, V> ObjectRecord<S, V> create(S stream, V value) {
        Assert.notNull(stream, "Stream must not be null");
        Assert.notNull(value, "Value must not be null");
        return new StreamRecords.ObjectBackedRecord<S, V>(stream, RecordId.autoGenerate(), value);
    }

    @Override
    public ObjectRecord<S, V> withId(RecordId var1);

    @Override
    public <SK> ObjectRecord<SK, V> withStreamKey(SK var1);

    default public <HK, HV> MapRecord<S, HK, HV> toMapRecord(HashMapper<? super V, HK, HV> mapper) {
        return Record.of(mapper.toHash(this.getValue())).withId(this.getId()).withStreamKey(this.getStream());
    }
}

