/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.client;

import java.util.List;
import org.springframework.context.Lifecycle;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketHttpHeaders;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.client.ConnectionManagerSupport;
import org.springframework.web.socket.client.WebSocketClient;
import org.springframework.web.socket.handler.LoggingWebSocketHandlerDecorator;

public class WebSocketConnectionManager
extends ConnectionManagerSupport {
    private final WebSocketClient client;
    private final WebSocketHandler webSocketHandler;
    @Nullable
    private WebSocketSession webSocketSession;
    private WebSocketHttpHeaders headers = new WebSocketHttpHeaders();

    public WebSocketConnectionManager(WebSocketClient client, WebSocketHandler webSocketHandler, String uriTemplate, Object ... uriVariables) {
        super(uriTemplate, uriVariables);
        this.client = client;
        this.webSocketHandler = this.decorateWebSocketHandler(webSocketHandler);
    }

    protected WebSocketHandler decorateWebSocketHandler(WebSocketHandler handler) {
        return new LoggingWebSocketHandlerDecorator(handler);
    }

    public void setSubProtocols(List<String> protocols) {
        this.headers.setSecWebSocketProtocol(protocols);
    }

    public List<String> getSubProtocols() {
        return this.headers.getSecWebSocketProtocol();
    }

    public void setOrigin(@Nullable String origin) {
        this.headers.setOrigin(origin);
    }

    @Nullable
    public String getOrigin() {
        return this.headers.getOrigin();
    }

    public void setHeaders(HttpHeaders headers) {
        this.headers.clear();
        this.headers.putAll(headers);
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public void startInternal() {
        if (this.client instanceof Lifecycle && !((Lifecycle)((Object)this.client)).isRunning()) {
            ((Lifecycle)((Object)this.client)).start();
        }
        super.startInternal();
    }

    @Override
    public void stopInternal() throws Exception {
        if (this.client instanceof Lifecycle && ((Lifecycle)((Object)this.client)).isRunning()) {
            ((Lifecycle)((Object)this.client)).stop();
        }
        super.stopInternal();
    }

    @Override
    protected void openConnection() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Connecting to WebSocket at " + this.getUri());
        }
        ListenableFuture<WebSocketSession> future = this.client.doHandshake(this.webSocketHandler, this.headers, this.getUri());
        future.addCallback(new ListenableFutureCallback<WebSocketSession>(){

            @Override
            public void onSuccess(@Nullable WebSocketSession result) {
                WebSocketConnectionManager.this.webSocketSession = result;
                WebSocketConnectionManager.this.logger.info("Successfully connected");
            }

            @Override
            public void onFailure(Throwable ex) {
                WebSocketConnectionManager.this.logger.error("Failed to connect", ex);
            }
        });
    }

    @Override
    protected void closeConnection() throws Exception {
        if (this.webSocketSession != null) {
            this.webSocketSession.close();
        }
    }

    @Override
    protected boolean isConnected() {
        return this.webSocketSession != null && this.webSocketSession.isOpen();
    }
}

