/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.log;

import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.log.Log;
import cn.hutool.log.level.Level;
import java.io.Serializable;

public abstract class AbstractLog
implements Log,
Serializable {
    private static final long serialVersionUID = -3211115409504005616L;
    private static final String FQCN = AbstractLog.class.getName();

    @Override
    public boolean isEnabled(Level level) {
        switch (level) {
            case TRACE: {
                return this.isTraceEnabled();
            }
            case DEBUG: {
                return this.isDebugEnabled();
            }
            case INFO: {
                return this.isInfoEnabled();
            }
            case WARN: {
                return this.isWarnEnabled();
            }
            case ERROR: {
                return this.isErrorEnabled();
            }
        }
        throw new Error(StrUtil.format((CharSequence)"Can not identify level: {}", new Object[]{level}));
    }

    @Override
    public void trace(Throwable t) {
        this.trace(t, ExceptionUtil.getSimpleMessage(t), new Object[0]);
    }

    @Override
    public void trace(String format, Object ... arguments) {
        this.trace(null, format, arguments);
    }

    @Override
    public void trace(Throwable t, String format, Object ... arguments) {
        this.trace(FQCN, t, format, arguments);
    }

    @Override
    public void debug(Throwable t) {
        this.debug(t, ExceptionUtil.getSimpleMessage(t), new Object[0]);
    }

    @Override
    public void debug(String format, Object ... arguments) {
        if (null != arguments && 1 == arguments.length && arguments[0] instanceof Throwable) {
            this.debug((Throwable)arguments[0], format, new Object[0]);
        } else {
            this.debug(null, format, arguments);
        }
    }

    @Override
    public void debug(Throwable t, String format, Object ... arguments) {
        this.debug(FQCN, t, format, arguments);
    }

    @Override
    public void info(Throwable t) {
        this.info(t, ExceptionUtil.getSimpleMessage(t), new Object[0]);
    }

    @Override
    public void info(String format, Object ... arguments) {
        if (null != arguments && 1 == arguments.length && arguments[0] instanceof Throwable) {
            this.info((Throwable)arguments[0], format, new Object[0]);
        } else {
            this.info(null, format, arguments);
        }
    }

    @Override
    public void info(Throwable t, String format, Object ... arguments) {
        this.info(FQCN, t, format, arguments);
    }

    @Override
    public void warn(Throwable t) {
        this.warn(t, ExceptionUtil.getSimpleMessage(t), new Object[0]);
    }

    @Override
    public void warn(String format, Object ... arguments) {
        if (null != arguments && 1 == arguments.length && arguments[0] instanceof Throwable) {
            this.warn((Throwable)arguments[0], format, new Object[0]);
        } else {
            this.warn(null, format, arguments);
        }
    }

    @Override
    public void warn(Throwable t, String format, Object ... arguments) {
        this.warn(FQCN, t, format, arguments);
    }

    @Override
    public void error(Throwable t) {
        this.error(t, ExceptionUtil.getSimpleMessage(t), new Object[0]);
    }

    @Override
    public void error(String format, Object ... arguments) {
        if (null != arguments && 1 == arguments.length && arguments[0] instanceof Throwable) {
            this.error((Throwable)arguments[0], format, new Object[0]);
        } else {
            this.error(null, format, arguments);
        }
    }

    @Override
    public void error(Throwable t, String format, Object ... arguments) {
        this.error(FQCN, t, format, arguments);
    }

    @Override
    public void log(Level level, String format, Object ... arguments) {
        if (null != arguments && 1 == arguments.length && arguments[0] instanceof Throwable) {
            this.log(level, (Throwable)arguments[0], format, new Object[0]);
        } else {
            this.log(level, null, format, arguments);
        }
    }

    @Override
    public void log(Level level, Throwable t, String format, Object ... arguments) {
        this.log(FQCN, level, t, format, arguments);
    }
}

