/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.querydsl.binding;

import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.CollectionPathBase;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.Optional;
import lombok.Generated;
import org.springframework.beans.BeanUtils;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.querydsl.EntityPathResolver;
import org.springframework.data.querydsl.binding.PathInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.ReflectionUtils;

class PropertyPathInformation
implements PathInformation {
    private final PropertyPath path;

    public static PropertyPathInformation of(String path, Class<?> type) {
        return PropertyPathInformation.of(PropertyPath.from(path, type));
    }

    public static PropertyPathInformation of(String path, TypeInformation<?> type) {
        return PropertyPathInformation.of(PropertyPath.from(path, type));
    }

    @Override
    public Class<?> getLeafType() {
        return this.path.getLeafProperty().getType();
    }

    @Override
    public Class<?> getLeafParentType() {
        return this.path.getLeafProperty().getOwningType().getType();
    }

    @Override
    public String getLeafProperty() {
        return this.path.getLeafProperty().getSegment();
    }

    @Override
    @Nullable
    public PropertyDescriptor getLeafPropertyDescriptor() {
        return BeanUtils.getPropertyDescriptor(this.getLeafParentType(), this.getLeafProperty());
    }

    @Override
    public String toDotPath() {
        return this.path.toDotPath();
    }

    @Override
    public Path<?> reifyPath(EntityPathResolver resolver) {
        return PropertyPathInformation.reifyPath(resolver, this.path, Optional.empty());
    }

    private static Path<?> reifyPath(EntityPathResolver resolver, PropertyPath path, Optional<Path<?>> base) {
        Optional<Path> map = base.filter(it -> it instanceof CollectionPathBase).map(CollectionPathBase.class::cast).map(CollectionPathBase::any).map(Path.class::cast).map(it -> PropertyPathInformation.reifyPath(resolver, path, Optional.of(it)));
        return map.orElseGet(() -> {
            Path entityPath = base.orElseGet(() -> resolver.createPath(path.getOwningType().getType()));
            Field field = org.springframework.data.util.ReflectionUtils.findRequiredField(entityPath.getClass(), path.getSegment());
            Object value = ReflectionUtils.getField(field, entityPath);
            PropertyPath next = path.next();
            if (next != null) {
                return PropertyPathInformation.reifyPath(resolver, next, Optional.of((Path)value));
            }
            return (Path)value;
        });
    }

    @Generated
    public String toString() {
        return "PropertyPathInformation(path=" + this.path + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PropertyPathInformation)) {
            return false;
        }
        PropertyPathInformation other = (PropertyPathInformation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PropertyPath this$path = this.path;
        PropertyPath other$path = other.path;
        return !(this$path == null ? other$path != null : !((Object)this$path).equals(other$path));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PropertyPathInformation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PropertyPath $path = this.path;
        result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
        return result;
    }

    @Generated
    private PropertyPathInformation(PropertyPath path) {
        this.path = path;
    }

    @Generated
    private static PropertyPathInformation of(PropertyPath path) {
        return new PropertyPathInformation(path);
    }
}

