/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.nio.ByteBuffer;
import java.util.Set;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactiveSubscription {
    public Mono<Void> subscribe(ByteBuffer ... var1);

    public Mono<Void> pSubscribe(ByteBuffer ... var1);

    public Mono<Void> unsubscribe();

    public Mono<Void> unsubscribe(ByteBuffer ... var1);

    public Mono<Void> pUnsubscribe();

    public Mono<Void> pUnsubscribe(ByteBuffer ... var1);

    public Set<ByteBuffer> getChannels();

    public Set<ByteBuffer> getPatterns();

    public Flux<Message<ByteBuffer, ByteBuffer>> receive();

    public Mono<Void> cancel();

    public static class PatternMessage<P, C, M>
    extends ChannelMessage<C, M> {
        private final P pattern;

        public PatternMessage(P pattern, C channel, M message) {
            super(channel, message);
            Assert.notNull(pattern, "Pattern must not be null!");
            this.pattern = pattern;
        }

        public P getPattern() {
            return this.pattern;
        }

        @Override
        public String toString() {
            return "PatternMessage{channel=" + this.getChannel() + ", pattern=" + this.pattern + ", message=" + this.getMessage() + '}';
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PatternMessage)) {
                return false;
            }
            PatternMessage other = (PatternMessage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            P this$pattern = this.getPattern();
            P other$pattern = other.getPattern();
            return !(this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof PatternMessage;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            P $pattern = this.getPattern();
            result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
            return result;
        }
    }

    public static class ChannelMessage<C, M>
    implements Message<C, M> {
        private final C channel;
        private final M message;

        public ChannelMessage(C channel, M message) {
            Assert.notNull(channel, "Channel must not be null!");
            Assert.notNull(message, "Message must not be null!");
            this.channel = channel;
            this.message = message;
        }

        @Override
        public C getChannel() {
            return this.channel;
        }

        @Override
        public M getMessage() {
            return this.message;
        }

        public String toString() {
            return "ChannelMessage {channel=" + this.channel + ", message=" + this.message + '}';
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelMessage)) {
                return false;
            }
            ChannelMessage other = (ChannelMessage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            C this$channel = this.getChannel();
            C other$channel = other.getChannel();
            if (this$channel == null ? other$channel != null : !this$channel.equals(other$channel)) {
                return false;
            }
            M this$message = this.getMessage();
            M other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !this$message.equals(other$message));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ChannelMessage;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            C $channel = this.getChannel();
            result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
            M $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            return result;
        }
    }

    public static interface Message<C, M> {
        public C getChannel();

        public M getMessage();
    }
}

