/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.support;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;

public class NativeMessageHeaderAccessor
extends MessageHeaderAccessor {
    public static final String NATIVE_HEADERS = "nativeHeaders";

    protected NativeMessageHeaderAccessor() {
        this((Map<String, List<String>>)null);
    }

    protected NativeMessageHeaderAccessor(@Nullable Map<String, List<String>> nativeHeaders) {
        if (!CollectionUtils.isEmpty(nativeHeaders)) {
            this.setHeader(NATIVE_HEADERS, new LinkedMultiValueMap<String, String>(nativeHeaders));
        }
    }

    protected NativeMessageHeaderAccessor(@Nullable Message<?> message) {
        super(message);
        Map map;
        if (message != null && (map = (Map)this.getHeader(NATIVE_HEADERS)) != null) {
            this.removeHeader(NATIVE_HEADERS);
            this.setHeader(NATIVE_HEADERS, new LinkedMultiValueMap(map));
        }
    }

    @Nullable
    protected Map<String, List<String>> getNativeHeaders() {
        return (Map)this.getHeader(NATIVE_HEADERS);
    }

    public Map<String, List<String>> toNativeHeaderMap() {
        Map<String, List<String>> map = this.getNativeHeaders();
        return map != null ? new LinkedMultiValueMap<String, String>(map) : Collections.emptyMap();
    }

    @Override
    public void setImmutable() {
        if (this.isMutable()) {
            Map<String, List<String>> map = this.getNativeHeaders();
            if (map != null) {
                this.removeHeader(NATIVE_HEADERS);
                this.setHeader(NATIVE_HEADERS, Collections.unmodifiableMap(map));
            }
            super.setImmutable();
        }
    }

    public boolean containsNativeHeader(String headerName) {
        Map<String, List<String>> map = this.getNativeHeaders();
        return map != null && map.containsKey(headerName);
    }

    @Nullable
    public List<String> getNativeHeader(String headerName) {
        Map<String, List<String>> map = this.getNativeHeaders();
        return map != null ? map.get(headerName) : null;
    }

    @Nullable
    public String getFirstNativeHeader(String headerName) {
        List<String> values;
        Map<String, List<String>> map = this.getNativeHeaders();
        if (map != null && (values = map.get(headerName)) != null) {
            return values.get(0);
        }
        return null;
    }

    public void setNativeHeader(String name, @Nullable String value) {
        Assert.state(this.isMutable(), "Already immutable");
        Map<String, List<String>> map = this.getNativeHeaders();
        if (value == null) {
            if (map != null && map.get(name) != null) {
                this.setModified(true);
                map.remove(name);
            }
            return;
        }
        if (map == null) {
            map = new LinkedMultiValueMap<String, String>(4);
            this.setHeader(NATIVE_HEADERS, map);
        }
        LinkedList<String> values = new LinkedList<String>();
        values.add(value);
        if (!ObjectUtils.nullSafeEquals(values, this.getHeader(name))) {
            this.setModified(true);
            map.put(name, values);
        }
    }

    public void addNativeHeader(String name, @Nullable String value) {
        Assert.state(this.isMutable(), "Already immutable");
        if (value == null) {
            return;
        }
        Map<String, List<String>> nativeHeaders = this.getNativeHeaders();
        if (nativeHeaders == null) {
            nativeHeaders = new LinkedMultiValueMap<String, String>(4);
            this.setHeader(NATIVE_HEADERS, nativeHeaders);
        }
        List values = nativeHeaders.computeIfAbsent(name, k -> new LinkedList());
        values.add(value);
        this.setModified(true);
    }

    public void addNativeHeaders(@Nullable MultiValueMap<String, String> headers) {
        if (headers == null) {
            return;
        }
        headers.forEach((key, values) -> values.forEach(value -> this.addNativeHeader((String)key, (String)value)));
    }

    @Nullable
    public List<String> removeNativeHeader(String name) {
        Assert.state(this.isMutable(), "Already immutable");
        Map<String, List<String>> nativeHeaders = this.getNativeHeaders();
        if (nativeHeaders == null) {
            return null;
        }
        return nativeHeaders.remove(name);
    }

    @Nullable
    public static String getFirstNativeHeader(String headerName, Map<String, Object> headers) {
        List values;
        Map map = (Map)headers.get(NATIVE_HEADERS);
        if (map != null && (values = (List)map.get(headerName)) != null) {
            return (String)values.get(0);
        }
        return null;
    }
}

