/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.codec;

public class Caesar {
    public static final String TABLE = "AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz";

    public static String encode(String message, int offset) {
        int len = message.length();
        char[] plain = message.toCharArray();
        for (int i2 = 0; i2 < len; ++i2) {
            char c = message.charAt(i2);
            if (!Character.isLetter(c)) continue;
            plain[i2] = Caesar.encodeChar(c, offset);
        }
        return new String(plain);
    }

    public static String decode(String cipherText, int offset) {
        int len = cipherText.length();
        char[] plain = cipherText.toCharArray();
        for (int i2 = 0; i2 < len; ++i2) {
            char c = cipherText.charAt(i2);
            if (!Character.isLetter(c)) continue;
            plain[i2] = Caesar.decodeChar(c, offset);
        }
        return new String(plain);
    }

    private static char encodeChar(char c, int offset) {
        int position = (TABLE.indexOf(c) + offset) % 52;
        return TABLE.charAt(position);
    }

    private static char decodeChar(char c, int offset) {
        int position = (TABLE.indexOf(c) - offset) % 52;
        if (position < 0) {
            position += 52;
        }
        return TABLE.charAt(position);
    }
}

