/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import java.nio.ByteBuffer;
import org.reactivestreams.Publisher;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.ClusterSlotHashUtil;
import org.springframework.data.redis.connection.ReactiveClusterListCommands;
import org.springframework.data.redis.connection.ReactiveListCommands;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveListCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveRedisConnection;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class LettuceReactiveClusterListCommands
extends LettuceReactiveListCommands
implements ReactiveClusterListCommands {
    LettuceReactiveClusterListCommands(LettuceReactiveRedisConnection connection) {
        super(connection);
    }

    @Override
    public Flux<ReactiveListCommands.PopResponse> bPop(Publisher<ReactiveListCommands.BPopCommand> commands) {
        return this.getConnection().execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull(command.getKeys(), "Keys must not be null!");
            Assert.notNull((Object)command.getDirection(), "Direction must not be null!");
            if (ClusterSlotHashUtil.isSameSlotForAllKeys(command.getKeys())) {
                return super.bPop(Mono.just(command));
            }
            return Mono.error(new InvalidDataAccessApiUsageException("All keys must map to the same slot for BPOP command."));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.ByteBufferResponse<ReactiveListCommands.RPopLPushCommand>> rPopLPush(Publisher<ReactiveListCommands.RPopLPushCommand> commands) {
        return this.getConnection().execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getDestination(), "Destination key must not be null!");
            if (ClusterSlotHashUtil.isSameSlotForAllKeys(command.getKey(), command.getDestination())) {
                return super.rPopLPush(Mono.just(command));
            }
            Mono<ReactiveRedisConnection.ByteBufferResponse> result = cmd.rpop(command.getKey()).flatMap(value -> cmd.lpush(command.getDestination(), value).map(x -> value));
            return result.map(value -> new ReactiveRedisConnection.ByteBufferResponse<ReactiveListCommands.RPopLPushCommand>((ReactiveListCommands.RPopLPushCommand)command, (ByteBuffer)value));
        }));
    }
}

