/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.SocketOptions;
import java.time.Duration;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.cassandra.CassandraProperties;
import org.springframework.boot.autoconfigure.cassandra.ClusterBuilderCustomizer;
import org.springframework.boot.autoconfigure.cassandra.ClusterFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Cluster.class})
@EnableConfigurationProperties(value={CassandraProperties.class})
public class CassandraAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public Cluster cassandraCluster(CassandraProperties properties, ObjectProvider<ClusterBuilderCustomizer> builderCustomizers, ObjectProvider<ClusterFactory> clusterFactory) {
        PropertyMapper map = PropertyMapper.get();
        Cluster.Builder builder = Cluster.builder().withClusterName(properties.getClusterName()).withPort(properties.getPort());
        map.from(properties::getUsername).whenNonNull().to(username -> builder.withCredentials(username, properties.getPassword()));
        map.from(properties::getCompression).whenNonNull().to(arg_0 -> ((Cluster.Builder)builder).withCompression(arg_0));
        QueryOptions queryOptions = this.getQueryOptions(properties);
        map.from(queryOptions).to(arg_0 -> ((Cluster.Builder)builder).withQueryOptions(arg_0));
        SocketOptions socketOptions = this.getSocketOptions(properties);
        map.from(socketOptions).to(arg_0 -> ((Cluster.Builder)builder).withSocketOptions(arg_0));
        map.from(properties::isSsl).whenTrue().toCall(() -> ((Cluster.Builder)builder).withSSL());
        PoolingOptions poolingOptions = this.getPoolingOptions(properties);
        map.from(poolingOptions).to(arg_0 -> ((Cluster.Builder)builder).withPoolingOptions(arg_0));
        map.from(properties::getContactPoints).as(StringUtils::toStringArray).to(arg_0 -> ((Cluster.Builder)builder).addContactPoints(arg_0));
        map.from(properties::isJmxEnabled).whenFalse().toCall(() -> ((Cluster.Builder)builder).withoutJMXReporting());
        builderCustomizers.orderedStream().forEach(customizer2 -> customizer2.customize(builder));
        return clusterFactory.getIfAvailable(() -> Cluster::buildFrom).create((Cluster.Initializer)builder);
    }

    private QueryOptions getQueryOptions(CassandraProperties properties) {
        PropertyMapper map = PropertyMapper.get();
        QueryOptions options = new QueryOptions();
        map.from(properties::getConsistencyLevel).whenNonNull().to(arg_0 -> ((QueryOptions)options).setConsistencyLevel(arg_0));
        map.from(properties::getSerialConsistencyLevel).whenNonNull().to(arg_0 -> ((QueryOptions)options).setSerialConsistencyLevel(arg_0));
        map.from(properties::getFetchSize).to(arg_0 -> ((QueryOptions)options).setFetchSize(arg_0));
        return options;
    }

    private SocketOptions getSocketOptions(CassandraProperties properties) {
        PropertyMapper map = PropertyMapper.get();
        SocketOptions options = new SocketOptions();
        map.from(properties::getConnectTimeout).whenNonNull().asInt(Duration::toMillis).to(arg_0 -> ((SocketOptions)options).setConnectTimeoutMillis(arg_0));
        map.from(properties::getReadTimeout).whenNonNull().asInt(Duration::toMillis).to(arg_0 -> ((SocketOptions)options).setReadTimeoutMillis(arg_0));
        return options;
    }

    private PoolingOptions getPoolingOptions(CassandraProperties properties) {
        PropertyMapper map = PropertyMapper.get();
        CassandraProperties.Pool poolProperties = properties.getPool();
        PoolingOptions options = new PoolingOptions();
        map.from(poolProperties::getIdleTimeout).whenNonNull().asInt(Duration::getSeconds).to(arg_0 -> ((PoolingOptions)options).setIdleTimeoutSeconds(arg_0));
        map.from(poolProperties::getPoolTimeout).whenNonNull().asInt(Duration::toMillis).to(arg_0 -> ((PoolingOptions)options).setPoolTimeoutMillis(arg_0));
        map.from(poolProperties::getHeartbeatInterval).whenNonNull().asInt(Duration::getSeconds).to(arg_0 -> ((PoolingOptions)options).setHeartbeatIntervalSeconds(arg_0));
        map.from(poolProperties::getMaxQueueSize).to(arg_0 -> ((PoolingOptions)options).setMaxQueueSize(arg_0));
        return options;
    }
}

